/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.client.event;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import rs.ltt.jmap.client.event.OnStateChangeListener;
import rs.ltt.jmap.common.entity.StateChange;

public class OnStateChangeListenerManager {
    private final Callback callback;
    private final List<OnStateChangeListener> onStateChangeListeners = new ArrayList<OnStateChangeListener>();

    public OnStateChangeListenerManager(Callback callback) {
        this.callback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOnStateChangeListener(OnStateChangeListener onStateChangeListener) {
        boolean empty;
        List<OnStateChangeListener> list = this.onStateChangeListeners;
        synchronized (list) {
            empty = this.onStateChangeListeners.isEmpty();
            this.onStateChangeListeners.add(onStateChangeListener);
        }
        if (empty) {
            this.callback.enable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOnStateChangeListener(OnStateChangeListener onStateChangeListener) {
        boolean empty;
        boolean removed;
        List<OnStateChangeListener> list = this.onStateChangeListeners;
        synchronized (list) {
            removed = this.onStateChangeListeners.remove(onStateChangeListener);
            empty = this.onStateChangeListeners.isEmpty();
        }
        if (removed && empty) {
            this.callback.disable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllListeners() {
        boolean nonEmpty;
        List<OnStateChangeListener> list = this.onStateChangeListeners;
        synchronized (list) {
            nonEmpty = !this.onStateChangeListeners.isEmpty();
            this.onStateChangeListeners.clear();
        }
        if (nonEmpty) {
            this.callback.disable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPushNotificationsEnabled() {
        List<OnStateChangeListener> list = this.onStateChangeListeners;
        synchronized (list) {
            return !this.onStateChangeListeners.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onStateChange(StateChange stateChange) {
        AtomicBoolean result = new AtomicBoolean(false);
        List<OnStateChangeListener> list = this.onStateChangeListeners;
        synchronized (list) {
            this.onStateChangeListeners.forEach(listener -> result.compareAndSet(false, listener.onStateChange(stateChange)));
        }
        return result.get();
    }

    public static interface Callback {
        public void disable();

        public void enable();
    }
}

