/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.client.event;

import java.time.Duration;
import java.util.concurrent.ThreadLocalRandom;
import rs.ltt.jmap.client.event.TruncatedBinaryExponentialBackoffStrategy;

@FunctionalInterface
public interface ReconnectionStrategy {
    public Duration getNextReconnectionAttempt(int var1);

    public static ReconnectionStrategy truncatedBinaryExponentialBackoffStrategy(int slotTime, int ceiling) {
        return new TruncatedBinaryExponentialBackoffStrategy(slotTime, ceiling);
    }

    public static ReconnectionStrategy alwaysAfter(Duration duration) {
        return attempt -> duration;
    }

    public static ReconnectionStrategy alwaysRandomlyAfter(Duration min, Duration max) {
        return attempt -> Duration.ofSeconds(ThreadLocalRandom.current().nextLong(min.getSeconds(), max.getSeconds()));
    }
}

