/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.client.event;

import com.google.common.base.Preconditions;
import com.google.common.math.Quantiles;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.Nullable;
import rs.ltt.jmap.client.Services;
import rs.ltt.jmap.client.api.SessionStateListener;
import rs.ltt.jmap.client.api.WebSocketJmapApiClient;
import rs.ltt.jmap.client.event.OnConnectionStateChangeListener;
import rs.ltt.jmap.client.event.OnStateChangeListener;
import rs.ltt.jmap.client.event.OnStateChangeListenerManager;
import rs.ltt.jmap.client.event.PushService;
import rs.ltt.jmap.client.event.ReconnectionStrategy;
import rs.ltt.jmap.client.event.State;
import rs.ltt.jmap.client.http.HttpAuthentication;
import rs.ltt.jmap.client.util.Durations;
import rs.ltt.jmap.common.entity.StateChange;
import rs.ltt.jmap.common.websocket.PushDisableWebSocketMessage;
import rs.ltt.jmap.common.websocket.PushEnableWebSocketMessage;
import rs.ltt.jmap.common.websocket.StateChangeWebSocketMessage;
import rs.ltt.jmap.common.websocket.WebSocketMessage;

public class WebSocketPushService
extends WebSocketJmapApiClient
implements PushService,
OnStateChangeListenerManager.Callback {
    private final OnStateChangeListenerManager onStateChangeListenerManager = new OnStateChangeListenerManager(this);
    private final List<OnConnectionStateChangeListener> onConnectionStateListeners = new ArrayList<OnConnectionStateChangeListener>();
    private ReconnectionStrategy reconnectionStrategy = ReconnectionStrategy.truncatedBinaryExponentialBackoffStrategy(60, 4);
    private Duration pingInterval = null;
    private String pushState = null;

    public WebSocketPushService(HttpUrl webSocketUrl, HttpAuthentication httpAuthentication, @Nullable SessionStateListener sessionStateListener) {
        super(webSocketUrl, httpAuthentication, sessionStateListener);
    }

    @Override
    public void addOnStateChangeListener(OnStateChangeListener onStateChangeListener) {
        this.onStateChangeListenerManager.addOnStateChangeListener(onStateChangeListener);
    }

    @Override
    public void removeOnStateChangeListener(OnStateChangeListener onStateChangeListener) {
        this.onStateChangeListenerManager.removeOnStateChangeListener(onStateChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOnConnectionStateListener(OnConnectionStateChangeListener onConnectionStateListener) {
        List<OnConnectionStateChangeListener> list = this.onConnectionStateListeners;
        synchronized (list) {
            this.onConnectionStateListeners.add(onConnectionStateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeOnConnectionStateListener(OnConnectionStateChangeListener onConnectionStateListener) {
        List<OnConnectionStateChangeListener> list = this.onConnectionStateListeners;
        synchronized (list) {
            this.onConnectionStateListeners.remove(onConnectionStateListener);
        }
    }

    @Override
    public State getConnectionState() {
        return this.state;
    }

    @Override
    public synchronized void disable() {
        if (this.state == State.CONNECTED) {
            this.disablePushNotifications();
        }
    }

    private void disablePushNotifications() {
        LOGGER.info("Disable push notifications");
        PushDisableWebSocketMessage message = PushDisableWebSocketMessage.builder().build();
        this.send((WebSocketMessage)message);
    }

    @Override
    public synchronized void enable() {
        if (this.readyToSend()) {
            this.enablePushNotifications();
        }
    }

    private void enablePushNotifications() {
        LOGGER.info("Enable push notifications");
        PushEnableWebSocketMessage message = PushEnableWebSocketMessage.builder().pushState(this.pushState).build();
        this.send((WebSocketMessage)message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void transitionTo(State state) {
        super.transitionTo(state);
        List<OnConnectionStateChangeListener> list = this.onConnectionStateListeners;
        synchronized (list) {
            for (OnConnectionStateChangeListener listener : this.onConnectionStateListeners) {
                listener.onConnectionStateChange(state);
            }
        }
        if (state.needsReconnect() && this.onStateChangeListenerManager.isPushNotificationsEnabled()) {
            this.scheduleReconnect();
        }
    }

    @Override
    protected Duration getPingInterval() {
        Duration duration;
        if (this.onStateChangeListenerManager.isPushNotificationsEnabled()) {
            if (this.pingInterval != null) {
                duration = this.pingInterval;
                LOGGER.info("Using configured ping interval of {}", (Object)duration);
            } else {
                int count = this.connectionDurations.size();
                if (count >= 5) {
                    Duration median = Duration.ofNanos(Math.round(Quantiles.median().compute((Collection)this.connectionDurations)));
                    duration = Durations.max(median.minus(PING_INTERVAL_TOLERANCE), PING_INTERVAL_TOLERANCE);
                    LOGGER.info("Using automatically adjusted ping interval of {}", (Object)duration);
                } else {
                    duration = Duration.ZERO;
                }
            }
        } else {
            duration = Duration.ZERO;
        }
        return duration;
    }

    @Override
    public void setPingInterval(Duration interval) {
        Preconditions.checkArgument((interval == null || interval.isZero() || Durations.isPositive(interval) ? 1 : 0) != 0, (Object)"PingInterval can not be negative");
        this.pingInterval = interval;
    }

    @Override
    protected boolean onWebSocketMessage(WebSocketMessage message) {
        if (super.onWebSocketMessage(message)) {
            return true;
        }
        if (message instanceof StateChangeWebSocketMessage) {
            StateChangeWebSocketMessage stateChange = (StateChangeWebSocketMessage)message;
            String pushState = stateChange.getPushState();
            if (this.onStateChangeListenerManager.onStateChange((StateChange)stateChange)) {
                this.pushState = pushState;
            }
            return true;
        }
        return false;
    }

    @Override
    protected synchronized void onOpen() {
        super.onOpen();
        if (this.onStateChangeListenerManager.isPushNotificationsEnabled()) {
            this.enablePushNotifications();
        }
    }

    @Override
    public synchronized void close() {
        this.onStateChangeListenerManager.removeAllListeners();
        super.close();
    }

    private void scheduleReconnect() {
        ScheduledFuture currentFuture = this.reconnectionFuture;
        int attempt = this.attempt;
        Duration reconnectIn = this.reconnectionStrategy.getNextReconnectionAttempt(attempt);
        LOGGER.info("schedule reconnect in {} for {} time", (Object)reconnectIn, (Object)(attempt + 1));
        this.reconnectionFuture = Services.SCHEDULED_EXECUTOR_SERVICE.schedule(() -> this.connectWebSocket(), reconnectIn.toMillis(), TimeUnit.MILLISECONDS);
        if (currentFuture != null) {
            currentFuture.cancel(true);
        }
    }
}

