/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.client.session;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import okhttp3.HttpUrl;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs.ltt.jmap.client.Services;
import rs.ltt.jmap.client.session.Session;
import rs.ltt.jmap.client.session.SessionCache;

public class FileSessionCache
implements SessionCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSessionCache.class);
    private static final ListeningExecutorService EXECUTOR_SERVICE = MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor());
    private final File directory;

    public FileSessionCache() {
        this.directory = null;
    }

    public FileSessionCache(@NonNull File directory) {
        this.directory = directory;
        LOGGER.debug("Initialize cache in {}", (Object)directory.getAbsolutePath());
    }

    @Override
    public void store(String username, HttpUrl sessionResource, Session session) {
        EXECUTOR_SERVICE.execute(() -> {
            File file = this.getFile(FileSessionCache.getFilename(username, sessionResource));
            try {
                FileWriter fileWriter = new FileWriter(file);
                Services.GSON.toJson((Object)session, (Appendable)fileWriter);
                fileWriter.flush();
                fileWriter.close();
            }
            catch (IOException e) {
                LOGGER.error("Unable to cache session in {}", (Object)file.getAbsolutePath());
            }
        });
    }

    @Override
    public ListenableFuture<Session> load(String username, HttpUrl sessionResource) {
        return EXECUTOR_SERVICE.submit(() -> this.loadFromFile(username, sessionResource));
    }

    private Session loadFromFile(String username, HttpUrl sessionResource) {
        File file = this.getFile(FileSessionCache.getFilename(username, sessionResource));
        try {
            Session session = (Session)Services.GSON.fromJson((Reader)new FileReader(file), Session.class);
            LOGGER.debug("Restored session from {}", (Object)file.getAbsolutePath());
            return session;
        }
        catch (FileNotFoundException e) {
            LOGGER.debug("Unable to restore session. {} not found", (Object)file.getAbsolutePath());
            return null;
        }
        catch (Exception e) {
            LOGGER.warn("Unable to restore session", (Throwable)e);
            return null;
        }
    }

    private File getFile(String filename) {
        if (this.directory == null) {
            return new File(filename);
        }
        return new File(this.directory, filename);
    }

    private static String getFilename(String username, HttpUrl sessionResource) {
        String name = username + ":" + (Serializable)(sessionResource == null ? Character.valueOf('\u0000') : sessionResource.toString());
        return "session-cache-" + Hashing.sha256().hashString((CharSequence)name, Charsets.UTF_8).toString();
    }
}

