/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.client.session;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.Serializable;
import java.util.HashMap;
import okhttp3.HttpUrl;
import rs.ltt.jmap.client.session.Session;
import rs.ltt.jmap.client.session.SessionCache;

public class InMemorySessionCache
implements SessionCache {
    private final HashMap<String, Session> cache = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(String username, HttpUrl sessionResource, Session session) {
        HashMap<String, Session> hashMap = this.cache;
        synchronized (hashMap) {
            this.cache.put(InMemorySessionCache.getKey(username, sessionResource), session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListenableFuture<Session> load(String username, HttpUrl sessionResource) {
        HashMap<String, Session> hashMap = this.cache;
        synchronized (hashMap) {
            return Futures.immediateFuture((Object)this.cache.get(InMemorySessionCache.getKey(username, sessionResource)));
        }
    }

    private static String getKey(String username, HttpUrl sessionResource) {
        String name = username + ":" + (Serializable)(sessionResource == null ? Character.valueOf('\u0000') : sessionResource.toString());
        return Hashing.sha256().hashString((CharSequence)name, Charsets.UTF_8).toString();
    }
}

