/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.client.session;

import com.damnhandy.uri.template.UriTemplate;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import okhttp3.HttpUrl;
import rs.ltt.jmap.client.event.CloseAfter;
import rs.ltt.jmap.common.SessionResource;
import rs.ltt.jmap.common.entity.AbstractIdentifiableEntity;
import rs.ltt.jmap.common.entity.Account;
import rs.ltt.jmap.common.entity.AccountCapability;
import rs.ltt.jmap.common.entity.Capability;
import rs.ltt.jmap.common.entity.Downloadable;

public class Session {
    private final HttpUrl base;
    private final SessionResource sessionResource;

    public Session(@Nonnull HttpUrl base, @Nonnull SessionResource sessionResource) {
        Preconditions.checkNotNull((Object)base, (Object)"Base URL for session must not be null");
        Preconditions.checkNotNull((Object)sessionResource, (Object)"Session Resource must not be null");
        this.base = base;
        this.sessionResource = sessionResource;
    }

    public HttpUrl getApiUrl() {
        String apiUrl = this.sessionResource.getApiUrl();
        HttpUrl.Builder builder = this.base.newBuilder(apiUrl);
        Preconditions.checkState((builder != null ? 1 : 0) != 0, (Object)String.format("Unable to assemble final API Url from base=%s and apiUrl=%s", this.base, apiUrl));
        return builder.build();
    }

    public HttpUrl getBase() {
        return this.base;
    }

    public HttpUrl getDownloadUrl(String accountId, Downloadable downloadable) {
        return this.getDownloadUrl(accountId, downloadable.getBlobId(), downloadable.getName(), downloadable.getType());
    }

    public HttpUrl getDownloadUrl(String accountId, String blobId, String name, String type) {
        String downloadUrl = this.sessionResource.getDownloadUrl();
        Preconditions.checkState((downloadUrl != null ? 1 : 0) != 0, (Object)"Session Resource did not contain a download Url");
        UriTemplate uriTemplate = UriTemplate.fromTemplate((String)downloadUrl).set("accountId", (Object)accountId).set("name", (Object)name).set("blobId", (Object)blobId).set("type", (Object)type);
        HttpUrl.Builder builder = this.base.newBuilder(uriTemplate.expand());
        Preconditions.checkState((builder != null ? 1 : 0) != 0, (Object)String.format("Unable to assemble final download Url from base=%s and downloadUrl=%s", this.base, downloadUrl));
        return builder.build();
    }

    public HttpUrl getEventSourceUrl(Collection<Class<? extends AbstractIdentifiableEntity>> types, CloseAfter closeAfter, Long ping) {
        String eventSourceUrl = this.sessionResource.getEventSourceUrl();
        Preconditions.checkState((eventSourceUrl != null ? 1 : 0) != 0, (Object)"Session Resource did not contain an event source Url");
        UriTemplate uriTemplate = UriTemplate.fromTemplate((String)eventSourceUrl).set("closeafter", (Object)closeAfter.toString().toLowerCase(Locale.US)).set("ping", (Object)ping);
        if (types.size() == 0) {
            uriTemplate.set("types", (Object)"*");
        } else {
            uriTemplate.set("types", types.stream().map(Class::getSimpleName).toArray(String[]::new));
        }
        HttpUrl.Builder builder = this.base.newBuilder(uriTemplate.expand());
        Preconditions.checkState((builder != null ? 1 : 0) != 0, (Object)String.format("Unable to assemble final eventSource Url from base=%s and eventSourceUrl=%s", this.base, eventSourceUrl));
        return builder.build();
    }

    public HttpUrl getUploadUrl(String accountId) {
        String uploadUrl = this.sessionResource.getUploadUrl();
        Preconditions.checkState((uploadUrl != null ? 1 : 0) != 0, (Object)"Session Resource did not contain an upload Url");
        UriTemplate uriTemplate = UriTemplate.fromTemplate((String)uploadUrl).set("accountId", (Object)accountId);
        HttpUrl.Builder builder = this.base.newBuilder(uriTemplate.expand());
        Preconditions.checkState((builder != null ? 1 : 0) != 0, (Object)String.format("Unable to assemble final upload Url from base=%s and uploadUrl=%s", this.base, uploadUrl));
        return builder.build();
    }

    public String getState() {
        return this.sessionResource.getState();
    }

    public String getPrimaryAccount(Class<? extends AccountCapability> clazz) {
        return this.sessionResource.getPrimaryAccount(clazz);
    }

    public Map<String, Account> getAccounts(Class<? extends AccountCapability> clazz) {
        return Maps.filterEntries((Map)this.sessionResource.getAccounts(), entry -> entry != null && ((Account)entry.getValue()).hasCapability(clazz));
    }

    public <T extends Capability> T getCapability(Class<T> clazz) {
        return (T)this.sessionResource.getCapability(clazz);
    }

    public <T extends AccountCapability> T getAccountCapability(String accountId, Class<T> clazz) {
        Account account = (Account)this.sessionResource.getAccounts().get(accountId);
        return (T)(account == null ? null : account.getCapability(clazz));
    }
}

