/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.client.session;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.concurrent.Executor;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpHeaders;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs.ltt.jmap.client.Services;
import rs.ltt.jmap.client.api.EndpointNotFoundException;
import rs.ltt.jmap.client.api.InvalidSessionResourceException;
import rs.ltt.jmap.client.api.UnauthorizedException;
import rs.ltt.jmap.client.http.HttpAuthentication;
import rs.ltt.jmap.client.session.Session;
import rs.ltt.jmap.client.session.SessionCache;
import rs.ltt.jmap.client.util.SettableCallFuture;
import rs.ltt.jmap.client.util.WellKnownUtil;
import rs.ltt.jmap.common.SessionResource;

public class SessionClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionClient.class);
    private final HttpUrl sessionResource;
    private final HttpAuthentication httpAuthentication;
    private SessionCache sessionCache;
    private Session currentSession = null;
    private ListenableFuture<Session> currentSessionFuture = Futures.immediateCancelledFuture();
    private boolean sessionResourceChanged = false;

    public SessionClient(HttpAuthentication authentication) {
        this.sessionResource = null;
        this.httpAuthentication = authentication;
    }

    public SessionClient(HttpAuthentication authentication, HttpUrl sessionResource) {
        this.sessionResource = sessionResource;
        this.httpAuthentication = authentication;
    }

    public synchronized ListenableFuture<Session> get() {
        HttpUrl resource;
        if (!this.sessionResourceChanged && this.currentSession != null) {
            return Futures.immediateFuture((Object)this.currentSession);
        }
        String username = this.httpAuthentication.getUsername();
        try {
            resource = this.getSessionResource();
        }
        catch (WellKnownUtil.MalformedUsernameException e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
        if (!this.currentSessionFuture.isDone()) {
            return this.currentSessionFuture;
        }
        this.currentSessionFuture = this.fetchSession(username, resource);
        return this.currentSessionFuture;
    }

    private HttpUrl getSessionResource() throws WellKnownUtil.MalformedUsernameException {
        String username = this.httpAuthentication.getUsername();
        if (this.sessionResource != null) {
            return this.sessionResource;
        }
        return WellKnownUtil.fromUsername(username);
    }

    private ListenableFuture<Session> fetchSession(String username, HttpUrl sessionResource) {
        SessionCache cache = this.sessionResourceChanged ? null : this.sessionCache;
        ListenableFuture<Session> cachedSessionFuture = cache == null ? Futures.immediateFuture(null) : cache.load(username, sessionResource);
        return Futures.transformAsync(cachedSessionFuture, session -> {
            if (session != null) {
                SessionClient sessionClient = this;
                synchronized (sessionClient) {
                    this.currentSession = session;
                }
                return Futures.immediateFuture((Object)session);
            }
            return this.fetchSession(sessionResource);
        }, (Executor)MoreExecutors.directExecutor());
    }

    private ListenableFuture<Session> fetchSession(final HttpUrl sessionResource) {
        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder.url(sessionResource);
        this.httpAuthentication.authenticate(requestBuilder);
        Call call = Services.OK_HTTP_CLIENT_LOGGING.newCall(requestBuilder.build());
        final SettableCallFuture settableFuture = SettableCallFuture.create(call);
        call.enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                settableFuture.setException(e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                try {
                    settableFuture.set(SessionClient.this.processResponse(sessionResource, response));
                }
                catch (Exception e) {
                    settableFuture.setException(e);
                }
            }
        });
        return settableFuture;
    }

    private Session processResponse(HttpUrl base, Response response) throws Exception {
        int code = response.code();
        if (code == 200 || code == 201) {
            ResponseBody body = response.body();
            if (body == null) {
                throw new InvalidSessionResourceException("Unable to fetch session object. Response body was empty.");
            }
            try (InputStreamReader reader = new InputStreamReader(body.byteStream());){
                SessionResource sessionResource;
                try {
                    sessionResource = (SessionResource)Services.GSON.fromJson((Reader)reader, SessionResource.class);
                }
                catch (JsonIOException | JsonSyntaxException e) {
                    throw new InvalidSessionResourceException(e);
                }
                this.validateSessionResource(sessionResource);
                HttpUrl currentBaseUrl = response.request().url();
                if (!base.equals((Object)currentBaseUrl)) {
                    LOGGER.info("Processed new base URL {}", (Object)currentBaseUrl.url());
                }
                Session session = new Session(currentBaseUrl, sessionResource);
                this.setSession(base, session);
                Session session2 = session;
                return session2;
            }
        }
        if (code == 401) {
            List challenges = HttpHeaders.parseChallenges((Headers)response.headers(), (String)"WWW-Authenticate");
            throw new UnauthorizedException(String.format("Session object(%s) was unauthorized", base.toString()), challenges);
        }
        throw new EndpointNotFoundException(String.format("Unable to fetch session object(%s)", base.toString()));
    }

    private void validateSessionResource(SessionResource sessionResource) throws InvalidSessionResourceException {
        if (sessionResource.getApiUrl() == null) {
            throw new InvalidSessionResourceException("Missing API URL");
        }
    }

    private synchronized void setSession(HttpUrl resource, Session session) {
        this.sessionResourceChanged = false;
        this.currentSession = session;
        SessionCache cache = this.sessionCache;
        if (cache != null) {
            String username = this.httpAuthentication.getUsername();
            LOGGER.debug("caching to {}", (Object)cache.getClass().getSimpleName());
            cache.store(username, resource, session);
        }
    }

    public synchronized void setLatestSessionState(String sessionState) {
        if (this.sessionResourceChanged) {
            return;
        }
        Session existingSession = this.currentSession;
        if (existingSession == null) {
            LOGGER.warn("Flag existing session as changed after session was null");
            this.sessionResourceChanged = true;
            return;
        }
        String oldState = existingSession.getState();
        if (oldState == null || !oldState.equals(sessionState)) {
            LOGGER.warn("Flag existing session as changed. was {} is {}", (Object)oldState, (Object)sessionState);
            this.sessionResourceChanged = true;
        }
    }

    public void setSessionCache(SessionCache sessionCache) {
        this.sessionCache = sessionCache;
    }
}

