/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.client.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import rs.ltt.jmap.client.MethodResponses;
import rs.ltt.jmap.common.Request;
import rs.ltt.jmap.common.Response;
import rs.ltt.jmap.common.method.MethodResponse;

public class ResponseAnalyzer {
    private final ImmutableMap<String, MethodResponses> methodResponsesMap;

    private ResponseAnalyzer(Map<String, MethodResponses> map) {
        this.methodResponsesMap = ImmutableMap.copyOf(map);
    }

    public static ResponseAnalyzer analyse(Response response) {
        ArrayListMultimap preMap = ArrayListMultimap.create();
        for (Response.Invocation invocation : response.getMethodResponses()) {
            preMap.put((Object)invocation.getId(), (Object)invocation.getMethodResponse());
        }
        HashMap<String, MethodResponses> actualMap = new HashMap<String, MethodResponses>();
        for (String id : preMap.keySet()) {
            List methodResponseList = preMap.get((Object)id);
            if (methodResponseList.size() == 0) {
                throw new AssertionError((Object)"Method response list can not be empty");
            }
            MethodResponses methodResponses = methodResponseList.size() == 1 ? new MethodResponses((MethodResponse)methodResponseList.get(0)) : new MethodResponses((MethodResponse)methodResponseList.get(0), methodResponseList.subList(1, methodResponseList.size()).toArray(new MethodResponse[0]));
            actualMap.put(id, methodResponses);
        }
        return new ResponseAnalyzer(actualMap);
    }

    public MethodResponses find(Request.Invocation invocation) {
        return (MethodResponses)this.methodResponsesMap.get((Object)invocation.getId());
    }
}

