/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.client.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import java.util.Locale;
import okhttp3.HttpUrl;

public final class WebSocketUtil {
    private static final ImmutableBiMap<String, String> SCHEME_MAP = new ImmutableBiMap.Builder().put((Object)"ws", (Object)"http").put((Object)"wss", (Object)"https").build();

    private WebSocketUtil() {
    }

    public static HttpUrl normalizeUrl(HttpUrl base, String url) {
        int schemeEndIndex = url.indexOf(":");
        if (schemeEndIndex == -1) {
            HttpUrl.Builder builder = base.newBuilder(url);
            Preconditions.checkState((builder != null ? 1 : 0) != 0, (Object)String.format("Unable to assemble final WebSocket URL from base=%s and url=%s", base, url));
            return builder.build();
        }
        String scheme = url.substring(0, schemeEndIndex).toLowerCase(Locale.ENGLISH);
        if (SCHEME_MAP.containsKey((Object)scheme)) {
            String normalizedScheme = (String)SCHEME_MAP.get((Object)scheme);
            String authority = url.substring(scheme.length() + 1);
            if (authority.startsWith("//")) {
                return HttpUrl.get((String)String.format("%s:%s", normalizedScheme, authority));
            }
            HttpUrl.Builder builder = base.newBuilder(authority);
            Preconditions.checkState((builder != null ? 1 : 0) != 0, (Object)String.format("Unable to assemble final WebSocket URL from base=%s and url=%s", base, url));
            builder.scheme(normalizedScheme);
            return builder.build();
        }
        return HttpUrl.get((String)url);
    }
}

