/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.client.util;

import okhttp3.HttpUrl;

public final class WellKnownUtil {
    private WellKnownUtil() {
    }

    public static HttpUrl fromUsername(String username) throws MalformedUsernameException {
        int index = username.lastIndexOf("@");
        if (index == -1) {
            throw new MalformedUsernameException("Username has no domain part");
        }
        String domain = username.substring(index + 1);
        if (domain.isEmpty()) {
            throw new MalformedUsernameException("Domain part was empty");
        }
        try {
            return new HttpUrl.Builder().scheme("https").host(domain).addPathSegment(".well-known").addPathSegment("jmap").build();
        }
        catch (IllegalArgumentException e) {
            throw new MalformedUsernameException(e);
        }
    }

    public static final class MalformedUsernameException
    extends Exception {
        private MalformedUsernameException(String message) {
            super(message);
        }

        public MalformedUsernameException(Exception e) {
            super(e);
        }
    }
}

