/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.Set;
import rs.ltt.jmap.gson.JmapAdapters;

public final class GsonUtils {
    public static final Gson REGULAR_GSON;
    public static final Gson NULL_SERIALIZING_GSON;

    private GsonUtils() {
    }

    public static void addAll(JsonObject to, Set<Map.Entry<String, JsonElement>> entries) {
        for (Map.Entry<String, JsonElement> entry : entries) {
            to.add(entry.getKey(), entry.getValue());
        }
    }

    static {
        GsonBuilder regularBuilder = new GsonBuilder();
        JmapAdapters.register(regularBuilder);
        REGULAR_GSON = regularBuilder.create();
        GsonBuilder nullSerializingBuilder = new GsonBuilder();
        nullSerializingBuilder.serializeNulls();
        NULL_SERIALIZING_GSON = nullSerializingBuilder.create();
    }
}

