/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.gson;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import rs.ltt.jmap.annotation.Type;
import rs.ltt.jmap.gson.GsonUtils;

public class TypeInjectionAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> typeToken) {
        Class clazz = typeToken.getRawType();
        Type annotation = clazz.getAnnotation(Type.class);
        if (annotation == null) {
            return null;
        }
        final String type = Strings.isNullOrEmpty((String)annotation.value()) ? clazz.getSimpleName() : annotation.value();
        final TypeAdapter delegateAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, typeToken);
        return new TypeAdapter<T>(){

            public void write(JsonWriter jsonWriter, T t) {
                JsonElement element = delegateAdapter.toJsonTree(t);
                if (element.isJsonObject()) {
                    JsonObject originalObject = element.getAsJsonObject();
                    JsonObject annotatedObject = TypeInjectionAdapterFactory.annotateWith(originalObject, type);
                    gson.toJson((JsonElement)annotatedObject, jsonWriter);
                } else {
                    gson.toJson(element, jsonWriter);
                }
            }

            public T read(JsonReader jsonReader) throws IOException {
                return delegateAdapter.read(jsonReader);
            }
        };
    }

    private static JsonObject annotateWith(JsonObject original, String type) {
        JsonObject annotatedObject = new JsonObject();
        annotatedObject.addProperty("@type", type);
        GsonUtils.addAll(annotatedObject, original.entrySet());
        return annotatedObject;
    }
}

