/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.gson.adapter;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;
import rs.ltt.jmap.common.websocket.AbstractApiWebSocketMessage;
import rs.ltt.jmap.common.websocket.ErrorResponseWebSocketMessage;
import rs.ltt.jmap.common.websocket.RequestWebSocketMessage;
import rs.ltt.jmap.common.websocket.ResponseWebSocketMessage;
import rs.ltt.jmap.common.websocket.WebSocketMessage;
import rs.ltt.jmap.gson.GsonUtils;

public class ApiWebSocketMessageTypeAdapter
extends TypeAdapter<AbstractApiWebSocketMessage> {
    private static final BiMap<String, Class<? extends AbstractApiWebSocketMessage>> MESSAGE_MAP = new ImmutableBiMap.Builder().put((Object)"RequestError", ErrorResponseWebSocketMessage.class).put((Object)"Request", RequestWebSocketMessage.class).put((Object)"Response", ResponseWebSocketMessage.class).build();

    public static void register(GsonBuilder builder) {
        for (Class clazz : MESSAGE_MAP.values()) {
            builder.registerTypeAdapter((Type)clazz, (Object)new ApiWebSocketMessageTypeAdapter());
        }
    }

    public void write(JsonWriter jsonWriter, AbstractApiWebSocketMessage message) throws IOException {
        jsonWriter.beginObject();
        jsonWriter.name("@type");
        jsonWriter.value((String)MESSAGE_MAP.inverse().get(message.getClass()));
        if (message instanceof RequestWebSocketMessage) {
            jsonWriter.name("id");
        } else {
            jsonWriter.name("requestId");
        }
        jsonWriter.value(message.getRequestId());
        JsonElement payload = GsonUtils.REGULAR_GSON.toJsonTree(message.getPayload());
        if (payload.isJsonObject()) {
            for (Map.Entry entry : payload.getAsJsonObject().entrySet()) {
                jsonWriter.name((String)entry.getKey());
                GsonUtils.NULL_SERIALIZING_GSON.toJson((JsonElement)entry.getValue(), jsonWriter);
            }
        } else {
            throw new JsonIOException("Payload serialization did not yield JsonObject");
        }
        jsonWriter.endObject();
    }

    public AbstractApiWebSocketMessage read(JsonReader jsonReader) throws IOException {
        WebSocketMessage message = (WebSocketMessage)GsonUtils.REGULAR_GSON.fromJson(jsonReader, WebSocketMessage.class);
        if (message instanceof AbstractApiWebSocketMessage) {
            return (AbstractApiWebSocketMessage)message;
        }
        throw new IOException(String.format("WebSocketMessage was of type %s", message.getClass().getName()));
    }
}

