/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.gson.adapter;

import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;

public class InstantTypeAdapter
extends TypeAdapter<Instant> {
    public static void register(GsonBuilder builder) {
        builder.registerTypeAdapter(Instant.class, (Object)new InstantTypeAdapter());
    }

    public void write(JsonWriter jsonWriter, Instant instant) throws IOException {
        if (instant == null) {
            jsonWriter.nullValue();
        } else {
            jsonWriter.value(DateTimeFormatter.ISO_INSTANT.format(instant));
        }
    }

    public Instant read(JsonReader jsonReader) throws IOException {
        if (jsonReader.peek() == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        String asString = jsonReader.nextString();
        return Instant.parse(asString);
    }
}

