/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.gson.adapter;

import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public class OffsetDateTimeTypeAdapter
extends TypeAdapter<OffsetDateTime> {
    public static void register(GsonBuilder builder) {
        builder.registerTypeAdapter(OffsetDateTime.class, (Object)new OffsetDateTimeTypeAdapter());
    }

    public void write(JsonWriter jsonWriter, OffsetDateTime offsetDateTime) throws IOException {
        if (offsetDateTime == null) {
            jsonWriter.nullValue();
        } else {
            jsonWriter.value(DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(offsetDateTime));
        }
    }

    public OffsetDateTime read(JsonReader jsonReader) throws IOException {
        if (jsonReader.peek() == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        String asString = jsonReader.nextString();
        return OffsetDateTime.parse(asString);
    }
}

