/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.gson.adapter;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import rs.ltt.jmap.common.Request;
import rs.ltt.jmap.common.method.MethodCall;
import rs.ltt.jmap.common.util.Mapper;
import rs.ltt.jmap.gson.GsonUtils;

public class RequestInvocationTypeAdapter
extends TypeAdapter<Request.Invocation> {
    public static void register(GsonBuilder builder) {
        builder.registerTypeAdapter(Request.Invocation.class, (Object)new RequestInvocationTypeAdapter());
    }

    public void write(JsonWriter jsonWriter, Request.Invocation invocation) throws IOException {
        MethodCall methodCall = invocation.getMethodCall();
        Class<?> clazz = methodCall.getClass();
        String name = (String)Mapper.METHOD_CALLS.inverse().get(clazz);
        if (name == null) {
            throw new JsonIOException(String.format("%s is not a registered @JmapMethod", clazz.getName()));
        }
        jsonWriter.beginArray();
        jsonWriter.value(name);
        GsonUtils.NULL_SERIALIZING_GSON.toJson(GsonUtils.REGULAR_GSON.toJsonTree((Object)methodCall), jsonWriter);
        jsonWriter.value(invocation.getId());
        jsonWriter.endArray();
    }

    public Request.Invocation read(JsonReader jsonReader) throws IOException {
        jsonReader.beginArray();
        String name = jsonReader.nextString();
        Class clazz = (Class)Mapper.METHOD_CALLS.get((Object)name);
        MethodCall methodCall = (MethodCall)GsonUtils.REGULAR_GSON.fromJson(jsonReader, (Type)clazz);
        String id = jsonReader.nextString();
        jsonReader.endArray();
        return new Request.Invocation(methodCall, id);
    }
}

