/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.gson.adapter;

import com.google.common.collect.ImmutableMap;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;
import rs.ltt.jmap.common.entity.AbstractIdentifiableEntity;
import rs.ltt.jmap.common.util.Mapper;

public class TypeStateMapAdapter
extends TypeAdapter<Map<Class<? extends AbstractIdentifiableEntity>, String>> {
    public static void register(GsonBuilder builder) {
        Type type = new TypeToken<Map<Class<? extends AbstractIdentifiableEntity>, String>>(){}.getType();
        builder.registerTypeAdapter(type, (Object)new TypeStateMapAdapter());
    }

    public void write(JsonWriter jsonWriter, Map<Class<? extends AbstractIdentifiableEntity>, String> typeStateMap) throws IOException {
        jsonWriter.beginObject();
        for (Map.Entry<Class<? extends AbstractIdentifiableEntity>, String> entry : typeStateMap.entrySet()) {
            Class<? extends AbstractIdentifiableEntity> entityClazz = entry.getKey();
            String entityType = (String)Mapper.ENTITIES.inverse().get(entityClazz);
            if (entityType == null) {
                throw new JsonIOException(String.format("%s is not a registered @JmapEntity", entityClazz.getSimpleName()));
            }
            String state = entry.getValue();
            jsonWriter.name(entityType);
            jsonWriter.value(state);
        }
        jsonWriter.endObject();
    }

    public Map<Class<? extends AbstractIdentifiableEntity>, String> read(JsonReader jsonReader) throws IOException {
        ImmutableMap.Builder mapBuilder = new ImmutableMap.Builder();
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            String entityType = jsonReader.nextName();
            String state = jsonReader.nextString();
            Class entityClazz = (Class)Mapper.ENTITIES.get((Object)entityType);
            if (entityClazz == null) continue;
            mapBuilder.put((Object)entityClazz, (Object)state);
        }
        jsonReader.endObject();
        return mapBuilder.build();
    }
}

