/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.gson.deserializer;

import com.google.common.collect.ImmutableMap;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;
import rs.ltt.jmap.common.entity.Capability;
import rs.ltt.jmap.common.util.Mapper;

public class CapabilitiesDeserializer
implements JsonDeserializer<Map<Class<? extends Capability>, Capability>> {
    public static void register(GsonBuilder builder) {
        Type type = new TypeToken<Map<Class<? extends Capability>, Capability>>(){}.getType();
        builder.registerTypeAdapter(type, (Object)new CapabilitiesDeserializer());
    }

    public Map<Class<? extends Capability>, Capability> deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String namespace = (String)entry.getKey();
            Class clazz = (Class)Mapper.CAPABILITIES.get((Object)namespace);
            if (clazz == null) continue;
            Capability capability = (Capability)context.deserialize((JsonElement)entry.getValue(), (Type)clazz);
            builder.put((Object)clazz, (Object)capability);
        }
        return builder.build();
    }
}

