/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.gson.deserializer;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import rs.ltt.jmap.common.entity.AbstractIdentifiableEntity;
import rs.ltt.jmap.common.entity.filter.Filter;
import rs.ltt.jmap.common.entity.filter.FilterOperator;
import rs.ltt.jmap.common.util.Mapper;

public class FilterDeserializer
implements JsonDeserializer<Filter<? extends AbstractIdentifiableEntity>> {
    public static void register(GsonBuilder builder) {
        for (Type type : Mapper.TYPE_TO_ENTITY_CLASS.keySet()) {
            builder.registerTypeAdapter(type, (Object)new FilterDeserializer());
        }
    }

    public Filter<? extends AbstractIdentifiableEntity> deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        boolean isOperator = jsonObject.has("operator") && jsonObject.has("conditions");
        Class entityClass = (Class)Mapper.TYPE_TO_ENTITY_CLASS.get((Object)type);
        if (isOperator) {
            return (Filter)context.deserialize(jsonElement, TypeToken.getParameterized(FilterOperator.class, (Type[])new Type[]{entityClass}).getType());
        }
        return (Filter)context.deserialize(jsonElement, (Type)Mapper.ENTITY_TO_FILTER_CONDITION.get((Object)entityClass));
    }
}

