/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.gson.deserializer;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import rs.ltt.jmap.common.ErrorResponse;
import rs.ltt.jmap.common.GenericResponse;
import rs.ltt.jmap.common.Response;

public class GenericResponseDeserializer
implements JsonDeserializer<GenericResponse> {
    public static void register(GsonBuilder builder) {
        builder.registerTypeAdapter(GenericResponse.class, (Object)new GenericResponseDeserializer());
    }

    public GenericResponse deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
        if (jsonElement.isJsonObject()) {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            if (jsonObject.has("type") && !jsonObject.has("methodResponses")) {
                return (GenericResponse)context.deserialize((JsonElement)jsonObject, ErrorResponse.class);
            }
            if (jsonObject.has("methodResponses") && !jsonObject.has("type")) {
                return (GenericResponse)context.deserialize((JsonElement)jsonObject, Response.class);
            }
            throw new JsonParseException("Unable to identify response as neither error nor response");
        }
        throw new JsonParseException("unexpected json type when parsing response");
    }
}

