/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.gson.deserializer;

import com.google.common.collect.ImmutableMap;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;
import rs.ltt.jmap.common.entity.AccountCapability;
import rs.ltt.jmap.common.util.Mapper;

public class PrimaryAccountsDeserializer
implements JsonDeserializer<Map<Class<? extends AccountCapability>, String>> {
    public static void register(GsonBuilder builder) {
        Type type = new TypeToken<Map<Class<? extends AccountCapability>, String>>(){}.getType();
        builder.registerTypeAdapter(type, (Object)new PrimaryAccountsDeserializer());
    }

    public Map<Class<? extends AccountCapability>, String> deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String namespace = (String)entry.getKey();
            Class clazz = (Class)Mapper.ACCOUNT_CAPABILITIES.get((Object)namespace);
            if (clazz == null) continue;
            String id = (String)context.deserialize((JsonElement)entry.getValue(), String.class);
            builder.put((Object)clazz, (Object)id);
        }
        return builder.build();
    }
}

