/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.gson.deserializer;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import rs.ltt.jmap.common.entity.PushMessage;
import rs.ltt.jmap.common.entity.PushVerification;
import rs.ltt.jmap.common.entity.StateChange;

public class PushMessageDeserializer
implements JsonDeserializer<PushMessage> {
    public static void register(GsonBuilder builder) {
        builder.registerTypeAdapter(PushMessage.class, (Object)new PushMessageDeserializer());
    }

    public PushMessage deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
        if (!jsonElement.isJsonObject()) {
            throw new JsonParseException("Expected JSON object for PushMessage. Got " + jsonElement.getClass().getSimpleName());
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        if (!jsonObject.has("@type")) {
            throw new JsonParseException("PushMessage had no @type attribute");
        }
        String messageType = jsonObject.get("@type").getAsString();
        if ("StateChange".equals(messageType)) {
            return (PushMessage)context.deserialize(jsonElement, StateChange.class);
        }
        if ("PushVerification".equals(messageType)) {
            return (PushMessage)context.deserialize(jsonElement, PushVerification.class);
        }
        throw new JsonParseException(String.format("Unknown PushMessage type %s", messageType));
    }
}

