/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.gson.deserializer;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import rs.ltt.jmap.common.Response;
import rs.ltt.jmap.common.method.MethodErrorResponse;
import rs.ltt.jmap.common.method.MethodResponse;
import rs.ltt.jmap.common.util.Mapper;

public class ResponseInvocationDeserializer
implements JsonDeserializer<Response.Invocation> {
    public static void register(GsonBuilder builder) {
        builder.registerTypeAdapter(Response.Invocation.class, (Object)new ResponseInvocationDeserializer());
    }

    public Response.Invocation deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject;
        String errorType;
        Class<MethodErrorResponse> customErrorClazz;
        if (!jsonElement.isJsonArray()) {
            throw new JsonParseException("Expected JSON array for invocation. Got " + jsonElement.getClass().getSimpleName());
        }
        JsonArray jsonArray = jsonElement.getAsJsonArray();
        if (jsonArray.size() != 3) {
            throw new JsonParseException("Invocation array has " + jsonArray.size() + " values. Expected 3");
        }
        if (!jsonArray.get(0).isJsonPrimitive()) {
            throw new JsonParseException("Name (index 0 of JsonArray) must be a primitive string");
        }
        String name = jsonArray.get(0).getAsString();
        JsonElement parameter = jsonArray.get(1);
        String id = jsonArray.get(2).getAsString();
        if (!parameter.isJsonObject()) {
            throw new JsonParseException("Parameter (index 1 of JsonArray) must be of type object");
        }
        Class<MethodErrorResponse> clazz = "error".equals(name) ? ((customErrorClazz = (Class<MethodErrorResponse>)Mapper.METHOD_ERROR_RESPONSES.get((Object)(errorType = (jsonObject = parameter.getAsJsonObject()).get("type").getAsString()))) != null ? customErrorClazz : MethodErrorResponse.class) : (Class<MethodErrorResponse>)Mapper.METHOD_RESPONSES.get((Object)name);
        if (clazz == null) {
            throw new UnknownMethodNameException(name);
        }
        MethodResponse methodResponse = (MethodResponse)context.deserialize(parameter, (Type)((Object)clazz));
        return new Response.Invocation(methodResponse, id);
    }

    public static class UnknownMethodNameException
    extends JsonParseException {
        private final String name;

        public UnknownMethodNameException(String name) {
            super(String.format("Unknown method name '%s'", name));
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

