/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.gson.deserializer;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import rs.ltt.jmap.common.ErrorResponse;
import rs.ltt.jmap.common.Request;
import rs.ltt.jmap.common.Response;
import rs.ltt.jmap.common.websocket.ErrorResponseWebSocketMessage;
import rs.ltt.jmap.common.websocket.PushDisableWebSocketMessage;
import rs.ltt.jmap.common.websocket.PushEnableWebSocketMessage;
import rs.ltt.jmap.common.websocket.RequestWebSocketMessage;
import rs.ltt.jmap.common.websocket.ResponseWebSocketMessage;
import rs.ltt.jmap.common.websocket.StateChangeWebSocketMessage;
import rs.ltt.jmap.common.websocket.WebSocketMessage;

public class WebSocketMessageDeserializer
implements JsonDeserializer<WebSocketMessage> {
    public static void register(GsonBuilder builder) {
        builder.registerTypeAdapter(WebSocketMessage.class, (Object)new WebSocketMessageDeserializer());
    }

    public WebSocketMessage deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
        if (!jsonElement.isJsonObject()) {
            throw new JsonParseException("Expected JSON object for WebSocketMessage. Got " + jsonElement.getClass().getSimpleName());
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        if (!jsonObject.has("@type")) {
            throw new JsonParseException("WebSocketMessage had no @type attribute");
        }
        String messageType = jsonObject.get("@type").getAsString();
        String requestId = WebSocketMessageDeserializer.getAsString(jsonObject, "requestId");
        String id = WebSocketMessageDeserializer.getAsString(jsonObject, "id");
        if ("Response".equals(messageType)) {
            Response response = (Response)context.deserialize(jsonElement, Response.class);
            return ResponseWebSocketMessage.builder().requestId(requestId).response(response).build();
        }
        if ("ErrorResponse".equals(messageType)) {
            ErrorResponse errorResponse = (ErrorResponse)context.deserialize(jsonElement, ErrorResponse.class);
            return ErrorResponseWebSocketMessage.builder().requestId(requestId).response(errorResponse).build();
        }
        if ("StateChange".equals(messageType)) {
            return (WebSocketMessage)context.deserialize(jsonElement, StateChangeWebSocketMessage.class);
        }
        if ("Request".equals(messageType)) {
            Request request = (Request)context.deserialize(jsonElement, Request.class);
            return RequestWebSocketMessage.builder().id(id).request(request).build();
        }
        if ("WebSocketPushEnable".equals(messageType)) {
            return (WebSocketMessage)context.deserialize(jsonElement, PushEnableWebSocketMessage.class);
        }
        if ("WebSocketPushDisable".equals(messageType)) {
            return (WebSocketMessage)context.deserialize(jsonElement, PushDisableWebSocketMessage.class);
        }
        throw new JsonParseException(String.format("Unknown WebSocketMessage type %s", messageType));
    }

    private static String getAsString(JsonObject jsonObject, String name) {
        if (jsonObject.has(name)) {
            JsonElement element = jsonObject.get(name);
            return element.isJsonNull() ? null : jsonObject.get(name).getAsString();
        }
        return null;
    }
}

