/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.gson.serializer;

import com.google.common.collect.ImmutableMap;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;
import rs.ltt.jmap.common.entity.Capability;
import rs.ltt.jmap.common.util.Mapper;

public class CapabilitiesSerializer
implements JsonSerializer<Map<Class<? extends Capability>, Capability>> {
    private static final ImmutableMap<Class<? extends Capability>, String> CAPABILITIES = Mapper.CAPABILITIES.inverse();

    public static void register(GsonBuilder builder) {
        Type type = new TypeToken<Map<Class<? extends Capability>, Capability>>(){}.getType();
        builder.registerTypeAdapter(type, (Object)new CapabilitiesSerializer());
    }

    public JsonElement serialize(Map<Class<? extends Capability>, Capability> map, Type type, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        for (Map.Entry<Class<? extends Capability>, Capability> entry : map.entrySet()) {
            Class<? extends Capability> clazz = entry.getKey();
            String name = (String)CAPABILITIES.get(clazz);
            jsonObject.add(name != null ? name : clazz.getSimpleName(), context.serialize((Object)entry.getValue()));
        }
        return jsonObject;
    }
}

