/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.gson.serializer;

import com.google.common.collect.ImmutableMap;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;
import rs.ltt.jmap.common.entity.AccountCapability;
import rs.ltt.jmap.common.util.Mapper;

public class PrimaryAccountsSerializer
implements JsonSerializer<Map<Class<? extends AccountCapability>, String>> {
    private static final ImmutableMap<Class<? extends AccountCapability>, String> ACCOUNT_CAPABILITIES = Mapper.ACCOUNT_CAPABILITIES.inverse();

    public static void register(GsonBuilder builder) {
        Type type = new TypeToken<Map<Class<? extends AccountCapability>, String>>(){}.getType();
        builder.registerTypeAdapter(type, (Object)new PrimaryAccountsSerializer());
    }

    public JsonElement serialize(Map<Class<? extends AccountCapability>, String> map, Type type, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        for (Map.Entry<Class<? extends AccountCapability>, String> entry : map.entrySet()) {
            Class<? extends AccountCapability> clazz = entry.getKey();
            String name = (String)ACCOUNT_CAPABILITIES.get(clazz);
            jsonObject.add(name != null ? name : clazz.getSimpleName(), context.serialize((Object)entry.getValue()));
        }
        return jsonObject;
    }
}

