/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.gson.serializer;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import rs.ltt.jmap.common.Response;
import rs.ltt.jmap.common.method.MethodErrorResponse;
import rs.ltt.jmap.common.method.MethodResponse;
import rs.ltt.jmap.common.util.Mapper;

public class ResponseInvocationSerializer
implements JsonSerializer<Response.Invocation> {
    public static void register(GsonBuilder builder) {
        builder.registerTypeAdapter(Response.Invocation.class, (Object)new ResponseInvocationSerializer());
    }

    public JsonElement serialize(Response.Invocation invocation, Type type, JsonSerializationContext context) {
        String id = invocation.getId();
        MethodResponse methodResponse = invocation.getMethodResponse();
        JsonArray jsonArray = new JsonArray();
        if (methodResponse instanceof MethodErrorResponse) {
            jsonArray.add("error");
            String errorType = (String)Mapper.METHOD_ERROR_RESPONSES.inverse().get(methodResponse.getClass());
            if (errorType == null) {
                throw new JsonIOException(String.format("Unable to serialize %s. Did you annotate the Method with @JmapError?", methodResponse.getClass().getSimpleName()));
            }
            JsonObject jsonObject = (JsonObject)context.serialize((Object)methodResponse);
            jsonObject.addProperty("type", errorType);
            jsonArray.add((JsonElement)jsonObject);
        } else {
            String name = (String)Mapper.METHOD_RESPONSES.inverse().get(methodResponse.getClass());
            if (name == null) {
                throw new JsonIOException(String.format("Unable to serialize %s. Did you annotate the method with @JmapMethod?", methodResponse.getClass().getSimpleName()));
            }
            jsonArray.add(name);
            jsonArray.add(context.serialize((Object)methodResponse));
        }
        jsonArray.add(id);
        return jsonArray;
    }
}

