/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.mua.util;

import java.util.Collection;
import rs.ltt.jmap.client.session.Session;
import rs.ltt.jmap.common.entity.Attachment;
import rs.ltt.jmap.common.entity.EmailBodyPart;
import rs.ltt.jmap.common.entity.capability.MailAccountCapability;

public final class AttachmentUtil {
    private AttachmentUtil() {
    }

    public static EmailBodyPart toEmailBodyPart(Attachment attachment) {
        if (attachment instanceof EmailBodyPart) {
            return (EmailBodyPart)attachment;
        }
        return EmailBodyPart.builder().blobId(attachment.getBlobId()).charset(attachment.getCharset()).type(attachment.getType()).name(attachment.getName()).size(attachment.getSize()).build();
    }

    public static EmailBodyPart toAnonymousEmailBodyPart(Attachment attachment) {
        return EmailBodyPart.builder().charset(attachment.getCharset()).type(attachment.getType()).name(attachment.getName()).size(attachment.getSize()).build();
    }

    public static void verifyAttachmentsDoNotExceedLimit(Session session, String account, Collection<? extends Attachment> attachments) {
        Long maxSizeAttachments;
        long combinedAttachmentSize = attachments.stream().map(a -> Math.max(0L, a.getSize())).reduce(0L, Long::sum);
        MailAccountCapability capability = (MailAccountCapability)session.getAccountCapability(account, MailAccountCapability.class);
        Long l = maxSizeAttachments = capability == null ? null : capability.getMaxSizeAttachmentsPerEmail();
        if (maxSizeAttachments != null && combinedAttachmentSize > maxSizeAttachments) {
            throw new CombinedAttachmentSizeExceedsLimitException(maxSizeAttachments);
        }
    }

    public static class CombinedAttachmentSizeExceedsLimitException
    extends RuntimeException {
        private final long limit;

        private CombinedAttachmentSizeExceedsLimitException(long limit) {
            super(String.format("The combined size of all attachments exceeds limit of %d", limit));
            this.limit = limit;
        }

        public long getLimit() {
            return this.limit;
        }
    }
}

