/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.mua.util;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import rs.ltt.jmap.common.entity.EmailAddress;
import rs.ltt.jmap.mua.util.EmailAddressToken;

public class EmailAddressTokenizer {
    public static List<EmailAddressToken> tokenize(CharSequence cs) {
        return EmailAddressTokenizer.tokenize(cs, false);
    }

    public static List<EmailAddressToken> tokenize(CharSequence cs, boolean requireExplicitDelimiter) {
        ImmutableList.Builder tokenBuilder = new ImmutableList.Builder();
        TokenReader tokenReader = new TokenReader(cs);
        ArrayList<Token> current = new ArrayList<Token>();
        while (tokenReader.hasMoreToken()) {
            Token token = tokenReader.read();
            current.add(token);
            if (token.tokenType != TokenType.DELIMITER && (requireExplicitDelimiter || token.tokenType != TokenType.END)) continue;
            if (EmailAddressTokenizer.moreThanJustWhiteSpaces(current)) {
                tokenBuilder.add((Object)EmailAddressTokenizer.combine(cs, current));
            }
            current.clear();
        }
        return tokenBuilder.build();
    }

    private static boolean moreThanJustWhiteSpaces(List<Token> tokens) {
        for (Token token : tokens) {
            if (EmailAddressTokenizer.isWhitespaceOrDelimiter(token)) continue;
            return true;
        }
        return false;
    }

    private static boolean isWhitespaceOrDelimiter(Token token) {
        return token.tokenType == TokenType.WHITESPACE || token.tokenType == TokenType.DELIMITER || token.tokenType == TokenType.END;
    }

    private static EmailAddressToken combine(CharSequence charSequence, List<Token> tokenList) {
        String emailAddress;
        String label;
        ArrayList<Token> labelTokens = new ArrayList<Token>();
        ArrayList<Token> addressTokens = new ArrayList<Token>();
        boolean inAddress = false;
        for (Token token : tokenList) {
            if (token.tokenType == TokenType.DELIMITER || token.tokenType == TokenType.END) continue;
            if (inAddress) {
                if (token.tokenType == TokenType.ADDRESS_END) {
                    inAddress = false;
                    continue;
                }
                addressTokens.add(token);
                continue;
            }
            if (token.tokenType == TokenType.ADDRESS_BEGIN) {
                inAddress = true;
                continue;
            }
            labelTokens.add(token);
        }
        if (labelTokens.size() > 0) {
            Token startToken = EmailAddressTokenizer.findFirstNonWhiteSpace(labelTokens, addressTokens.size() > 0);
            Token endToken = EmailAddressTokenizer.findLastNonWhiteSpace(labelTokens, addressTokens.size() > 0);
            if (startToken != null && endToken != null) {
                int start = startToken.start;
                int end = endToken.end;
                label = charSequence.subSequence(start, end + 1).toString();
            } else {
                label = null;
            }
        } else {
            label = null;
        }
        if (addressTokens.size() > 0) {
            int start = EmailAddressTokenizer.findFirstNonWhiteSpace(addressTokens, (boolean)false).start;
            int end = EmailAddressTokenizer.findLastNonWhiteSpace(addressTokens, (boolean)false).end;
            emailAddress = charSequence.subSequence(start, end + 1).toString();
        } else {
            emailAddress = label;
            label = null;
        }
        return new EmailAddressToken(tokenList.get((int)0).start, tokenList.get((int)(tokenList.size() - 1)).end, EmailAddress.builder().email(emailAddress).name(label).build());
    }

    private static Token findFirstNonWhiteSpace(List<Token> tokens, boolean removeQuote) {
        for (int i = 0; i < tokens.size(); ++i) {
            Token token = tokens.get(i);
            if (token.tokenType == TokenType.WHITESPACE || removeQuote && token.tokenType == TokenType.QUOTE_BEGIN) continue;
            return token;
        }
        return null;
    }

    private static Token findLastNonWhiteSpace(List<Token> tokens, boolean removeQuote) {
        for (int i = tokens.size() - 1; i >= 0; --i) {
            Token token = tokens.get(i);
            if (token.tokenType == TokenType.WHITESPACE || removeQuote && token.tokenType == TokenType.QUOTE_END) continue;
            return token;
        }
        return null;
    }

    private static class TokenReader {
        private final ArrayDeque<Token> queue = new ArrayDeque();

        private TokenReader(CharSequence cs) {
            int length = cs.length();
            int start = 0;
            boolean inQuote = false;
            for (int i = 0; i < length; ++i) {
                char c = cs.charAt(i);
                if (inQuote) {
                    if (!this.isQuotationSymbol(c)) continue;
                    if (start < i) {
                        this.queue.add(new Token(TokenType.TEXT, start, i - 1));
                    }
                    this.queue.add(new Token(TokenType.QUOTE_END, i, i));
                    inQuote = false;
                    start = i + 1;
                    continue;
                }
                if (this.isWhitespace(c)) {
                    if (start < i) {
                        this.queue.add(new Token(TokenType.TEXT, start, i - 1));
                    }
                    this.queue.add(new Token(TokenType.WHITESPACE, i, i));
                    start = i + 1;
                    continue;
                }
                if (this.isDelimiter(c)) {
                    if (start < i) {
                        this.queue.add(new Token(TokenType.TEXT, start, i - 1));
                    }
                    this.queue.add(new Token(TokenType.DELIMITER, i, i));
                    start = i + 1;
                    continue;
                }
                if (this.isQuotationSymbol(c)) {
                    if (start < i) {
                        this.queue.add(new Token(TokenType.TEXT, start, i - 1));
                    }
                    this.queue.add(new Token(TokenType.QUOTE_BEGIN, i, i));
                    inQuote = true;
                    start = i + 1;
                    continue;
                }
                if (this.isAddressBegin(c)) {
                    if (start < i) {
                        this.queue.add(new Token(TokenType.TEXT, start, i - 1));
                    }
                    this.queue.add(new Token(TokenType.ADDRESS_BEGIN, i, i));
                    start = i + 1;
                    continue;
                }
                if (!this.isAddressEnd(c)) continue;
                if (start < i) {
                    this.queue.add(new Token(TokenType.TEXT, start, i - 1));
                }
                this.queue.add(new Token(TokenType.ADDRESS_END, i, i));
                start = i + 1;
            }
            if (start < length) {
                this.queue.add(new Token(TokenType.TEXT, start, length - 1));
            }
            this.queue.add(new Token(TokenType.END, length - 1, length - 1));
        }

        private boolean isDelimiter(char c) {
            return c == ';' || c == ',';
        }

        private boolean isWhitespace(char c) {
            return Character.isWhitespace(c);
        }

        private boolean isQuotationSymbol(char c) {
            return c == '\"';
        }

        private boolean isAddressBegin(char c) {
            return c == '<';
        }

        private boolean isAddressEnd(char c) {
            return c == '>';
        }

        public boolean hasMoreToken() {
            return !this.queue.isEmpty();
        }

        public Token read() {
            return this.queue.poll();
        }
    }

    private static class Token {
        public final TokenType tokenType;
        public final int start;
        public final int end;

        private Token(TokenType tokenType, int start, int end) {
            this.tokenType = tokenType;
            this.start = start;
            this.end = end;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("tokenType", (Object)this.tokenType).add("start", this.start).add("end", this.end).toString();
        }
    }

    private static enum TokenType {
        TEXT,
        ADDRESS_BEGIN,
        ADDRESS_END,
        QUOTE_BEGIN,
        QUOTE_END,
        WHITESPACE,
        DELIMITER,
        END;

    }
}

