/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.mua.util;

import com.google.common.base.CharMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class EmailBodyUtil {
    public static List<Block> parse(List<String> textBodies) {
        return textBodies.stream().map(EmailBodyUtil::parse).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static List<Block> parse(String body) {
        String[] lines = body.split("\\n");
        ArrayList<Block> blocks = new ArrayList<Block>();
        Block currentBlock = null;
        for (String currentLine : lines) {
            QuoteIndicator quoteIndicator = QuoteIndicator.quoteDepth(currentLine);
            if (currentBlock == null) {
                currentBlock = new Block(quoteIndicator.depth);
                blocks.add(currentBlock);
            } else if (quoteIndicator.depth != currentBlock.depth) {
                currentBlock = new Block(quoteIndicator.depth);
                blocks.add(currentBlock);
            }
            String withQuoteRemoved = quoteIndicator.chars > 0 ? currentLine.substring(quoteIndicator.chars) : currentLine;
            currentBlock.append(withQuoteRemoved);
        }
        return blocks;
    }

    public static class QuoteIndicator {
        private final int chars;
        private final int depth;

        QuoteIndicator(int chars, int depth) {
            this.chars = chars;
            this.depth = depth;
        }

        static QuoteIndicator quoteDepth(String line) {
            int quoteDepth = 0;
            int chars = 0;
            for (int i = 0; i < line.length(); ++i) {
                char c = line.charAt(i);
                if (c == '>') {
                    ++quoteDepth;
                } else if (c != ' ') break;
                ++chars;
            }
            return new QuoteIndicator(chars, quoteDepth);
        }
    }

    public static class Block {
        private static final float X = 0.1f;
        private static final float N = 0.15f;
        private static final float VOLATILITY_THRESHOLD = 12.0f;
        private final int depth;
        private final ArrayList<String> lines = new ArrayList();

        Block(int depth) {
            this.depth = depth;
        }

        public void append(String line) {
            this.lines.add(line);
        }

        public String toString() {
            int max;
            int lastLineLength = max = this.maxLineLength();
            boolean breakNextBlockUnderscore = false;
            boolean breakNextBlockHyphen = false;
            boolean skipNextBreak = false;
            StringBuilder stringBuilder = new StringBuilder();
            for (String line : this.lines) {
                String firstWord;
                String[] words = line.split("\\s+");
                String string = firstWord = words.length == 0 ? "" : words[0];
                if (stringBuilder.length() != 0) {
                    boolean listItem;
                    boolean bl = listItem = firstWord.length() <= 3 && (firstWord.endsWith(")") || firstWord.endsWith(":")) || line.startsWith("* ") || line.startsWith("- ") || firstWord.matches("\\[[0-9]+]:");
                    if (!skipNextBreak) {
                        if (breakNextBlockUnderscore || breakNextBlockHyphen) {
                            stringBuilder.append('\n');
                        } else if (line.isEmpty()) {
                            stringBuilder.append('\n');
                        } else if (listItem || line.contains("__")) {
                            stringBuilder.append('\n');
                        } else if (lastLineLength + firstWord.length() < max) {
                            stringBuilder.append('\n');
                        } else {
                            stringBuilder.append(' ');
                        }
                    }
                    lastLineLength = line.length();
                    skipNextBreak = false;
                } else if (line.isEmpty() && this.depth == 0) {
                    stringBuilder.append('\n');
                    skipNextBreak = true;
                }
                skipNextBreak |= line.endsWith(" ");
                boolean blockBoundaryUnderscore = line.matches("_{2,}");
                boolean blockBoundaryHypen = line.matches("-{2,}");
                breakNextBlockUnderscore = breakNextBlockUnderscore && !line.isEmpty() && !blockBoundaryUnderscore || blockBoundaryUnderscore && !breakNextBlockUnderscore;
                breakNextBlockHyphen = breakNextBlockHyphen && !line.isEmpty() && !blockBoundaryHypen || blockBoundaryHypen && !breakNextBlockHyphen;
                stringBuilder.append(line);
            }
            return stringBuilder.toString();
        }

        private int maxLineLength() {
            ArrayList<Integer> lineLengths = new ArrayList<Integer>();
            int max = 0;
            for (String line : this.lines) {
                if (CharMatcher.is((char)' ').countIn((CharSequence)line) <= 1) continue;
                max = Math.max(line.length(), max);
                lineLengths.add(line.length());
            }
            Collections.sort(lineLengths);
            if (lineLengths.size() <= 1) {
                return max;
            }
            List topXPercent = lineLengths.subList((int)(0.8999999985098839 * (double)lineLengths.size()) - 1, lineLengths.size());
            double sum = 0.0;
            int top = (Integer)lineLengths.get(lineLengths.size() - 1);
            for (int i = 0; i < lineLengths.size() - 1; ++i) {
                int bottom = (Integer)lineLengths.get(i);
                sum += (double)((float)top / (float)bottom - 1.0f);
            }
            double avg = sum / (double)topXPercent.size();
            if (avg >= 12.0) {
                return Integer.MAX_VALUE;
            }
            if ((float)((Integer)topXPercent.get(topXPercent.size() - 1) - (Integer)topXPercent.get(0)) <= 0.15f * (float)((Integer)topXPercent.get(topXPercent.size() - 1)).intValue()) {
                return topXPercent.size() % 2 == 1 ? (Integer)topXPercent.get(topXPercent.size() / 2) : ((Integer)topXPercent.get(topXPercent.size() / 2 - 1) + (Integer)topXPercent.get(topXPercent.size() / 2)) / 2;
            }
            return max;
        }

        public int getDepth() {
            return this.depth;
        }
    }
}

