/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.mua.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import rs.ltt.jmap.common.entity.EmailAddress;
import rs.ltt.jmap.common.entity.IdentifiableEmailWithAddresses;
import rs.ltt.jmap.common.entity.IdentifiableEmailWithSubject;
import rs.ltt.jmap.common.entity.IdentifiableEmailWithTime;

public class EmailUtil {
    private static final String RESPONSE_PREFIX = "Re";
    private static final List<String> RESPONSE_PREFIXES = Arrays.asList("re", "aw");

    private EmailUtil() {
    }

    public static String getResponseSubject(IdentifiableEmailWithSubject emailWithSubject) {
        String subject = emailWithSubject.getSubject();
        int length = subject.length();
        if (length <= 3) {
            return EmailUtil.subjectWithPrefix(subject);
        }
        String prefix = subject.substring(0, 3);
        if (prefix.charAt(2) == ':' && RESPONSE_PREFIXES.contains(prefix.substring(0, 2).toLowerCase())) {
            return EmailUtil.subjectWithPrefix(subject.substring(3));
        }
        return EmailUtil.subjectWithPrefix(subject);
    }

    public static String subjectWithPrefix(String subject) {
        return String.format("%s: %s", RESPONSE_PREFIX, subject.trim());
    }

    public static Instant getEffectiveDate(IdentifiableEmailWithTime email) {
        Instant receivedAt = email.getReceivedAt();
        OffsetDateTime sentAt = email.getSentAt();
        if (sentAt == null) {
            return receivedAt;
        }
        if (receivedAt.isBefore(sentAt.toInstant())) {
            return receivedAt;
        }
        return sentAt.toInstant();
    }

    public static ReplyAddresses reply(IdentifiableEmailWithAddresses emailWithAddresses) {
        Collection replyTo = emailWithAddresses.getReplyTo();
        if (replyTo != null && replyTo.size() > 0) {
            return new ReplyAddresses(replyTo);
        }
        return new ReplyAddresses(EmailUtil.replyTo(emailWithAddresses));
    }

    private static Collection<EmailAddress> replyTo(IdentifiableEmailWithAddresses emailWithAddresses) {
        Collection from = emailWithAddresses.getFrom();
        if (from != null && !from.isEmpty()) {
            return from;
        }
        Collection sender = emailWithAddresses.getSender();
        if (sender != null && !sender.isEmpty()) {
            return sender;
        }
        return Collections.emptyList();
    }

    public static ReplyAddresses replyAll(IdentifiableEmailWithAddresses emailWithAddresses) {
        return EmailUtil.replyAll(emailWithAddresses, Collections.emptyList());
    }

    public static ReplyAddresses replyAll(IdentifiableEmailWithAddresses emailWithAddresses, Collection<String> identityEmailAddresses) {
        Collection replyTo = emailWithAddresses.getReplyTo();
        Collection cc = emailWithAddresses.getCc();
        if (replyTo != null && replyTo.size() > 0 && (cc == null || cc.isEmpty())) {
            return new ReplyAddresses(replyTo);
        }
        Collection to = emailWithAddresses.getTo();
        ImmutableList.Builder ccBuilder = new ImmutableList.Builder();
        if (to != null) {
            for (EmailAddress address : to) {
                if (Iterables.any(identityEmailAddresses, i -> i.equalsIgnoreCase(address.getEmail()))) continue;
                ccBuilder.add((Object)address);
            }
        }
        if (cc != null) {
            ccBuilder.addAll((Iterable)cc);
        }
        if (replyTo != null && replyTo.size() > 0) {
            return new ReplyAddresses(replyTo, (Collection<EmailAddress>)ccBuilder.build());
        }
        return new ReplyAddresses(EmailUtil.replyTo(emailWithAddresses), (Collection<EmailAddress>)ccBuilder.build());
    }

    public static class ReplyAddresses {
        private final Collection<EmailAddress> to;
        private final Collection<EmailAddress> cc;

        public ReplyAddresses(Collection<EmailAddress> to) {
            this.to = to;
            this.cc = Collections.emptyList();
        }

        public ReplyAddresses(Collection<EmailAddress> to, Collection<EmailAddress> cc) {
            this.to = to;
            this.cc = cc;
        }

        public Collection<EmailAddress> getTo() {
            return this.to;
        }

        public Collection<EmailAddress> getCc() {
            return this.cc;
        }
    }
}

