/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.mua.util;

import com.google.common.base.CaseFormat;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import rs.ltt.jmap.common.entity.Role;
import rs.ltt.jmap.mua.util.KeywordUtil;
import rs.ltt.jmap.mua.util.LabelWithCount;

public class KeywordLabel
implements LabelWithCount,
Serializable {
    private final String keyword;
    private final Role role;

    KeywordLabel(String keyword, Role role) {
        this.keyword = keyword;
        this.role = role;
    }

    @Override
    public String getName() {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.role.name());
    }

    @Override
    public Role getRole() {
        return this.role;
    }

    @Override
    public Integer getCount() {
        return null;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public static KeywordLabel of(String keyword) {
        Role role = (Role)KeywordUtil.KEYWORD_ROLE.get((Object)keyword);
        Preconditions.checkArgument((role != null ? 1 : 0) != 0, (Object)"Keyword has no known mailbox mapping");
        return new KeywordLabel(keyword, role);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeywordLabel that = (KeywordLabel)o;
        return Objects.equal((Object)this.keyword, (Object)that.keyword) && this.role == that.role;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.keyword, this.role});
    }
}

