/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.mua.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.Collection;
import rs.ltt.jmap.common.entity.IdentifiableEmailWithKeywords;
import rs.ltt.jmap.common.entity.Role;

public class KeywordUtil {
    public static final BiMap<String, Role> KEYWORD_ROLE = new ImmutableBiMap.Builder().put((Object)"$flagged", (Object)Role.FLAGGED).put((Object)"$draft", (Object)Role.DRAFTS).build();

    public static boolean anyHas(Collection<? extends IdentifiableEmailWithKeywords> emails, String keyword) {
        for (IdentifiableEmailWithKeywords identifiableEmailWithKeywords : emails) {
            if (!identifiableEmailWithKeywords.getKeywords().containsKey(keyword)) continue;
            return true;
        }
        return false;
    }

    public static boolean everyHas(Collection<? extends IdentifiableEmailWithKeywords> emails, String keyword) {
        for (IdentifiableEmailWithKeywords identifiableEmailWithKeywords : emails) {
            if (identifiableEmailWithKeywords.getKeywords().containsKey(keyword)) continue;
            return false;
        }
        return true;
    }

    public static boolean seen(IdentifiableEmailWithKeywords email) {
        return email.getKeywords().getOrDefault("$seen", false);
    }

    public static boolean draft(IdentifiableEmailWithKeywords email) {
        return email.getKeywords().getOrDefault("$draft", false);
    }
}

