/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.mua.util;

import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.ComparisonChain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import rs.ltt.jmap.common.entity.Role;
import rs.ltt.jmap.mua.util.KeywordLabel;
import rs.ltt.jmap.mua.util.KeywordUtil;
import rs.ltt.jmap.mua.util.Label;
import rs.ltt.jmap.mua.util.LabelWithCount;

public class LabelUtil {
    public static final Comparator<? super Label> COMPARATOR = (a, b) -> ComparisonChain.start().compare(LabelUtil.order(a.getRole()), LabelUtil.order(b.getRole())).compare((Comparable)((Object)Strings.nullToEmpty((String)a.getName())), (Comparable)((Object)Strings.nullToEmpty((String)b.getName()))).result();
    private static final Collection<KeywordLabel> KEYWORD_LABELS = Collections2.transform((Collection)KeywordUtil.KEYWORD_ROLE.entrySet(), entry -> new KeywordLabel((String)entry.getKey(), (Role)entry.getValue()));

    public static List<LabelWithCount> fillUpAndSort(List<? extends LabelWithCount> mailboxes) {
        ArrayList<LabelWithCount> labels = new ArrayList<LabelWithCount>(mailboxes);
        for (KeywordLabel keywordLabel : KEYWORD_LABELS) {
            if (LabelUtil.anyIsRole(mailboxes, keywordLabel.getRole())) continue;
            labels.add(keywordLabel);
        }
        labels.sort(COMPARATOR);
        return labels;
    }

    private static boolean anyIsRole(Collection<? extends Label> labels, Role role) {
        for (Label label : labels) {
            if (label.getRole() != role) continue;
            return true;
        }
        return false;
    }

    private static int order(Role role) {
        if (role == null) {
            return 0;
        }
        switch (role) {
            case INBOX: {
                return -30;
            }
            case FLAGGED: {
                return -20;
            }
            case IMPORTANT: {
                return -10;
            }
            case ALL: {
                return 10;
            }
            case ARCHIVE: {
                return 20;
            }
            case SENT: {
                return 30;
            }
            case DRAFTS: {
                return 40;
            }
            case JUNK: {
                return 50;
            }
            case TRASH: {
                return 60;
            }
        }
        return 70;
    }
}

