/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.mua.util;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import rs.ltt.jmap.common.entity.EmailAddress;
import rs.ltt.jmap.mua.util.EmailAddressUtil;

public class MailToUri {
    private static final String MAIL_TO = "mailto";
    private static final String TO = "to";
    private static final String CC = "cc";
    private static final String BCC = "bcc";
    private static final String IN_REPLY_TO = "in-reply-to";
    private static final String SUBJECT = "subject";
    private static final String BODY = "body";
    private final Collection<EmailAddress> to;
    private final Collection<EmailAddress> cc;
    private final Collection<EmailAddress> bcc;
    private final String inReplyTo;
    private final String subject;
    private final String body;

    @Nullable
    public static MailToUri parse(String input) {
        try {
            return MailToUri.get(input);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Nonnull
    public static MailToUri get(String input) throws IllegalArgumentException {
        return MailToUri.get(input, true);
    }

    @Nonnull
    public static MailToUri get(String input, boolean stripNames) throws IllegalArgumentException {
        int schemeDelimiter = input.indexOf(":");
        if (schemeDelimiter < 0) {
            throw new IllegalArgumentException("No scheme detected");
        }
        if (input.substring(0, schemeDelimiter).equals(MAIL_TO)) {
            String query;
            String to;
            int queryDelimiter;
            int n = queryDelimiter = input.length() > schemeDelimiter ? input.indexOf("?", schemeDelimiter + 1) : -1;
            if (queryDelimiter > 0) {
                to = input.substring(schemeDelimiter + 1, queryDelimiter);
                query = input.substring(queryDelimiter + 1);
            } else {
                to = input.substring(schemeDelimiter + 1);
                query = null;
            }
            Map<String, String> parameters = MailToUri.parseQuery(query);
            String cc = parameters.get(CC);
            String bcc = parameters.get(BCC);
            String inReplyTo = parameters.get(IN_REPLY_TO);
            String subject = parameters.get(SUBJECT);
            String body = parameters.get(BODY);
            MailToUriBuilder mailToUriBuilder = MailToUri.builder();
            if (Strings.isNullOrEmpty((String)to)) {
                String toParameter = parameters.get(TO);
                if (toParameter != null) {
                    mailToUriBuilder.to(MailToUri.parseEmailAddress(toParameter, stripNames));
                }
            } else {
                List<EmailAddress> addresses = EmailAddressUtil.parse(MailToUri.decode(to));
                MailToUri.throwOnName(addresses);
                mailToUriBuilder.to(addresses);
            }
            if (cc != null) {
                mailToUriBuilder.cc(MailToUri.parseEmailAddress(cc, stripNames));
            }
            if (bcc != null) {
                mailToUriBuilder.bcc(MailToUri.parseEmailAddress(bcc, stripNames));
            }
            mailToUriBuilder.inReplyTo(inReplyTo);
            mailToUriBuilder.subject(subject);
            mailToUriBuilder.body(body);
            return mailToUriBuilder.build();
        }
        throw new IllegalArgumentException("Unknown scheme");
    }

    private static void throwOnName(Collection<EmailAddress> addresses) throws IllegalArgumentException {
        for (EmailAddress address : addresses) {
            if (Strings.isNullOrEmpty((String)address.getName())) continue;
            throw new IllegalArgumentException("Mailto address must not have a name");
        }
    }

    private static Map<String, String> parseQuery(String query) {
        if (query == null) {
            return Collections.emptyMap();
        }
        ImmutableMap.Builder mapBuilder = new ImmutableMap.Builder();
        for (String parameter : query.split("&")) {
            String[] parts = parameter.split("=", 2);
            if (parts.length != 2) continue;
            mapBuilder.put((Object)parts[0].toLowerCase(Locale.ENGLISH), (Object)MailToUri.decode(parts[1]));
        }
        return mapBuilder.build();
    }

    private static String decode(String input) {
        try {
            return URLDecoder.decode(input, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Collection<EmailAddress> parseEmailAddress(String address, boolean stripNames) {
        return stripNames ? MailToUri.stripNames(EmailAddressUtil.parse(address)) : EmailAddressUtil.parse(address);
    }

    private static Collection<EmailAddress> stripNames(Collection<EmailAddress> emailAddresses) {
        return Collections2.transform(emailAddresses, (Function)new Function<EmailAddress, EmailAddress>(){

            @Nullable
            public EmailAddress apply(@Nullable EmailAddress emailAddress) {
                if (emailAddress == null || Strings.isNullOrEmpty((String)emailAddress.getName())) {
                    return emailAddress;
                }
                return EmailAddress.builder().email(emailAddress.getEmail()).build();
            }
        });
    }

    MailToUri(Collection<EmailAddress> to, Collection<EmailAddress> cc, Collection<EmailAddress> bcc, String inReplyTo, String subject, String body) {
        this.to = to;
        this.cc = cc;
        this.bcc = bcc;
        this.inReplyTo = inReplyTo;
        this.subject = subject;
        this.body = body;
    }

    public static MailToUriBuilder builder() {
        return new MailToUriBuilder();
    }

    public Collection<EmailAddress> getTo() {
        return this.to;
    }

    public Collection<EmailAddress> getCc() {
        return this.cc;
    }

    public Collection<EmailAddress> getBcc() {
        return this.bcc;
    }

    public String getInReplyTo() {
        return this.inReplyTo;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getBody() {
        return this.body;
    }

    public String toString() {
        return "MailToUri(to=" + this.getTo() + ", cc=" + this.getCc() + ", bcc=" + this.getBcc() + ", inReplyTo=" + this.getInReplyTo() + ", subject=" + this.getSubject() + ", body=" + this.getBody() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MailToUri)) {
            return false;
        }
        MailToUri other = (MailToUri)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Collection<EmailAddress> this$to = this.getTo();
        Collection<EmailAddress> other$to = other.getTo();
        if (this$to == null ? other$to != null : !((Object)this$to).equals(other$to)) {
            return false;
        }
        Collection<EmailAddress> this$cc = this.getCc();
        Collection<EmailAddress> other$cc = other.getCc();
        if (this$cc == null ? other$cc != null : !((Object)this$cc).equals(other$cc)) {
            return false;
        }
        Collection<EmailAddress> this$bcc = this.getBcc();
        Collection<EmailAddress> other$bcc = other.getBcc();
        if (this$bcc == null ? other$bcc != null : !((Object)this$bcc).equals(other$bcc)) {
            return false;
        }
        String this$inReplyTo = this.getInReplyTo();
        String other$inReplyTo = other.getInReplyTo();
        if (this$inReplyTo == null ? other$inReplyTo != null : !this$inReplyTo.equals(other$inReplyTo)) {
            return false;
        }
        String this$subject = this.getSubject();
        String other$subject = other.getSubject();
        if (this$subject == null ? other$subject != null : !this$subject.equals(other$subject)) {
            return false;
        }
        String this$body = this.getBody();
        String other$body = other.getBody();
        return !(this$body == null ? other$body != null : !this$body.equals(other$body));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MailToUri;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Collection<EmailAddress> $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : ((Object)$to).hashCode());
        Collection<EmailAddress> $cc = this.getCc();
        result = result * 59 + ($cc == null ? 43 : ((Object)$cc).hashCode());
        Collection<EmailAddress> $bcc = this.getBcc();
        result = result * 59 + ($bcc == null ? 43 : ((Object)$bcc).hashCode());
        String $inReplyTo = this.getInReplyTo();
        result = result * 59 + ($inReplyTo == null ? 43 : $inReplyTo.hashCode());
        String $subject = this.getSubject();
        result = result * 59 + ($subject == null ? 43 : $subject.hashCode());
        String $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        return result;
    }

    public static class MailToUriBuilder {
        private ArrayList<EmailAddress> to;
        private ArrayList<EmailAddress> cc;
        private ArrayList<EmailAddress> bcc;
        private String inReplyTo;
        private String subject;
        private String body;

        MailToUriBuilder() {
        }

        public MailToUriBuilder to(EmailAddress to) {
            if (this.to == null) {
                this.to = new ArrayList();
            }
            this.to.add(to);
            return this;
        }

        public MailToUriBuilder to(Collection<? extends EmailAddress> to) {
            if (to == null) {
                throw new NullPointerException("to cannot be null");
            }
            if (this.to == null) {
                this.to = new ArrayList();
            }
            this.to.addAll(to);
            return this;
        }

        public MailToUriBuilder clearTo() {
            if (this.to != null) {
                this.to.clear();
            }
            return this;
        }

        public MailToUriBuilder cc(EmailAddress cc) {
            if (this.cc == null) {
                this.cc = new ArrayList();
            }
            this.cc.add(cc);
            return this;
        }

        public MailToUriBuilder cc(Collection<? extends EmailAddress> cc) {
            if (cc == null) {
                throw new NullPointerException("cc cannot be null");
            }
            if (this.cc == null) {
                this.cc = new ArrayList();
            }
            this.cc.addAll(cc);
            return this;
        }

        public MailToUriBuilder clearCc() {
            if (this.cc != null) {
                this.cc.clear();
            }
            return this;
        }

        public MailToUriBuilder bcc(EmailAddress bcc) {
            if (this.bcc == null) {
                this.bcc = new ArrayList();
            }
            this.bcc.add(bcc);
            return this;
        }

        public MailToUriBuilder bcc(Collection<? extends EmailAddress> bcc) {
            if (bcc == null) {
                throw new NullPointerException("bcc cannot be null");
            }
            if (this.bcc == null) {
                this.bcc = new ArrayList();
            }
            this.bcc.addAll(bcc);
            return this;
        }

        public MailToUriBuilder clearBcc() {
            if (this.bcc != null) {
                this.bcc.clear();
            }
            return this;
        }

        public MailToUriBuilder inReplyTo(String inReplyTo) {
            this.inReplyTo = inReplyTo;
            return this;
        }

        public MailToUriBuilder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public MailToUriBuilder body(String body) {
            this.body = body;
            return this;
        }

        public MailToUri build() {
            List<EmailAddress> bcc;
            List<EmailAddress> cc;
            List<EmailAddress> to;
            switch (this.to == null ? 0 : this.to.size()) {
                case 0: {
                    to = Collections.emptyList();
                    break;
                }
                case 1: {
                    to = Collections.singletonList(this.to.get(0));
                    break;
                }
                default: {
                    to = Collections.unmodifiableList(new ArrayList<EmailAddress>(this.to));
                }
            }
            switch (this.cc == null ? 0 : this.cc.size()) {
                case 0: {
                    cc = Collections.emptyList();
                    break;
                }
                case 1: {
                    cc = Collections.singletonList(this.cc.get(0));
                    break;
                }
                default: {
                    cc = Collections.unmodifiableList(new ArrayList<EmailAddress>(this.cc));
                }
            }
            switch (this.bcc == null ? 0 : this.bcc.size()) {
                case 0: {
                    bcc = Collections.emptyList();
                    break;
                }
                case 1: {
                    bcc = Collections.singletonList(this.bcc.get(0));
                    break;
                }
                default: {
                    bcc = Collections.unmodifiableList(new ArrayList<EmailAddress>(this.bcc));
                }
            }
            return new MailToUri(to, cc, bcc, this.inReplyTo, this.subject, this.body);
        }

        public String toString() {
            return "MailToUri.MailToUriBuilder(to=" + this.to + ", cc=" + this.cc + ", bcc=" + this.bcc + ", inReplyTo=" + this.inReplyTo + ", subject=" + this.subject + ", body=" + this.body + ")";
        }
    }
}

