/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.mua.util;

import java.util.Collection;
import java.util.Objects;
import rs.ltt.jmap.common.entity.Identifiable;
import rs.ltt.jmap.common.entity.IdentifiableMailboxWithRoleAndName;

public class MailboxPreconditions {
    public static void checkNonMatches(Collection<? extends IdentifiableMailboxWithRoleAndName> a, Collection<? extends IdentifiableMailboxWithRoleAndName> b) {
        for (IdentifiableMailboxWithRoleAndName identifiableMailboxWithRoleAndName : a) {
            MailboxPreconditions.checkNonMatches(identifiableMailboxWithRoleAndName, b);
        }
        for (IdentifiableMailboxWithRoleAndName identifiableMailboxWithRoleAndName : b) {
            MailboxPreconditions.checkNonMatches(identifiableMailboxWithRoleAndName, a);
        }
    }

    private static void checkNonMatches(IdentifiableMailboxWithRoleAndName a, Collection<? extends IdentifiableMailboxWithRoleAndName> b) {
        if (a.matchesAny(b)) {
            throw new IllegalArgumentException(String.format("Mailbox with role %s and name %s appears in both arguments", a.getRole(), a.getName()));
        }
    }

    public static void checkAllIdentifiable(Collection<? extends Identifiable> entities, String message) {
        if (entities.stream().anyMatch(e -> Objects.isNull(e.getId()))) {
            throw new IllegalArgumentException(message);
        }
    }
}

