/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.mua.util;

import com.google.common.base.CaseFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import rs.ltt.jmap.common.entity.IdentifiableEmailWithMailboxIds;
import rs.ltt.jmap.common.entity.IdentifiableMailboxWithRole;
import rs.ltt.jmap.common.entity.Mailbox;
import rs.ltt.jmap.common.entity.Role;

public class MailboxUtil {
    public static List<String> RESERVED_MAILBOX_NAMES = Arrays.stream(Role.values()).map(MailboxUtil::humanReadable).collect(Collectors.toList());

    @Nullable
    public static IdentifiableMailboxWithRole find(Collection<? extends IdentifiableMailboxWithRole> mailboxes, Role role) {
        for (IdentifiableMailboxWithRole identifiableMailboxWithRole : mailboxes) {
            if (identifiableMailboxWithRole.getRole() != role) continue;
            return identifiableMailboxWithRole;
        }
        return null;
    }

    public static boolean anyWithRole(Collection<? extends IdentifiableMailboxWithRole> mailboxes, Role role) {
        for (IdentifiableMailboxWithRole identifiableMailboxWithRole : mailboxes) {
            if (identifiableMailboxWithRole.getRole() != role) continue;
            return true;
        }
        return false;
    }

    public static Mailbox create(Role role) {
        return Mailbox.builder().role(role).name(MailboxUtil.humanReadable(role)).build();
    }

    public static String humanReadable(Role role) {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, role.toString());
    }

    public static boolean anyIn(Collection<? extends IdentifiableEmailWithMailboxIds> emails, String mailboxId) {
        for (IdentifiableEmailWithMailboxIds identifiableEmailWithMailboxIds : emails) {
            if (!identifiableEmailWithMailboxIds.getMailboxIds().containsKey(mailboxId)) continue;
            return true;
        }
        return false;
    }
}

