/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.mua.util;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import rs.ltt.jmap.client.MethodResponses;
import rs.ltt.jmap.common.entity.AddedItem;
import rs.ltt.jmap.common.entity.Email;
import rs.ltt.jmap.common.entity.TypedState;
import rs.ltt.jmap.common.method.response.email.GetEmailMethodResponse;
import rs.ltt.jmap.common.method.response.email.QueryChangesEmailMethodResponse;
import rs.ltt.jmap.common.method.response.email.QueryEmailMethodResponse;
import rs.ltt.jmap.mua.util.QueryResultItem;

public class QueryResult {
    public final QueryResultItem[] items;
    public final TypedState<Email> queryState;
    public final boolean canCalculateChanges;
    public final long position;
    public final Long total;
    public final TypedState<Email> objectState;

    private QueryResult(@Nonnull QueryResultItem[] items, TypedState<Email> queryState, boolean canCalculateChanges, long position, Long total, TypedState<Email> objectState) {
        this.items = items;
        this.queryState = queryState;
        this.canCalculateChanges = canCalculateChanges;
        this.position = position;
        this.total = total;
        this.objectState = objectState;
    }

    @Nonnull
    public static ListenableFuture<QueryResult> of(ListenableFuture<MethodResponses> queryResponsesFuture, ListenableFuture<MethodResponses> getThreadIdsResponsesFuture) {
        return Futures.transform((ListenableFuture)Futures.allAsList((ListenableFuture[])new ListenableFuture[]{queryResponsesFuture, getThreadIdsResponsesFuture}), methodResponses -> {
            Preconditions.checkState((methodResponses != null && methodResponses.size() == 2 ? 1 : 0) != 0, (Object)"Unable to create QueryResult. Invalid number of input method responses");
            QueryEmailMethodResponse queryResponse = (QueryEmailMethodResponse)((MethodResponses)methodResponses.get(0)).getMain(QueryEmailMethodResponse.class);
            GetEmailMethodResponse getThreadIdsResponse = (GetEmailMethodResponse)((MethodResponses)methodResponses.get(1)).getMain(GetEmailMethodResponse.class);
            return QueryResult.of(queryResponse, getThreadIdsResponse);
        }, (Executor)MoreExecutors.directExecutor());
    }

    public static QueryResult of(QueryEmailMethodResponse queryEmailMethodResponse, GetEmailMethodResponse emailMethodResponse) {
        String[] emailIds = queryEmailMethodResponse.getIds();
        QueryResultItem[] resultItems = new QueryResultItem[emailIds.length];
        ImmutableMap<String, String> emailIdToThreadIdMap = QueryResult.map(emailMethodResponse);
        for (int i = 0; i < emailIds.length; ++i) {
            String emailId = emailIds[i];
            resultItems[i] = QueryResultItem.of(emailId, (String)emailIdToThreadIdMap.get((Object)emailId));
        }
        return new QueryResult(resultItems, (TypedState<Email>)queryEmailMethodResponse.getTypedQueryState(), queryEmailMethodResponse.isCanCalculateChanges(), queryEmailMethodResponse.getPosition(), queryEmailMethodResponse.getTotal(), (TypedState<Email>)emailMethodResponse.getTypedState());
    }

    private static ImmutableMap<String, String> map(GetEmailMethodResponse emailMethodResponse) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (Email email : (Email[])emailMethodResponse.getList()) {
            builder.put((Object)email.getId(), (Object)email.getThreadId());
        }
        return builder.build();
    }

    public static List<AddedItem<QueryResultItem>> of(QueryChangesEmailMethodResponse queryChangesEmailMethodResponse, GetEmailMethodResponse emailMethodResponse) {
        List addedEmailIdItems = QueryResult.nullToEmpty(queryChangesEmailMethodResponse.getAdded());
        ImmutableList.Builder builder = new ImmutableList.Builder();
        ImmutableMap<String, String> emailIdToThreadIdMap = QueryResult.map(emailMethodResponse);
        for (AddedItem addedItem : addedEmailIdItems) {
            String emailId = (String)addedItem.getItem();
            builder.add((Object)AddedItem.of((Object)QueryResultItem.of(emailId, (String)emailIdToThreadIdMap.get((Object)emailId)), (long)addedItem.getIndex()));
        }
        return builder.build();
    }

    private static <T> List<AddedItem<T>> nullToEmpty(List<AddedItem<T>> value) {
        return value == null ? Collections.emptyList() : value;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("items", (Object)this.items).add("queryState", this.queryState).add("canCalculateChanges", this.canCalculateChanges).add("position", this.position).add("total", (Object)this.total).add("objectState", this.objectState).toString();
    }
}

