/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.mua.util;

import com.google.common.base.Preconditions;
import rs.ltt.jmap.common.entity.Comparator;
import rs.ltt.jmap.common.entity.IdentifiableMailboxWithRole;
import rs.ltt.jmap.common.entity.filter.EmailFilterCondition;
import rs.ltt.jmap.common.entity.filter.Filter;
import rs.ltt.jmap.common.entity.filter.FilterOperator;
import rs.ltt.jmap.common.entity.query.EmailQuery;

public final class StandardQueries {
    public static final Comparator[] SORT_DEFAULT = new Comparator[]{new Comparator("receivedAt", Boolean.valueOf(false))};

    private StandardQueries() {
    }

    public static EmailQuery mailbox(IdentifiableMailboxWithRole mailbox) {
        return StandardQueries.mailbox(mailbox.getId());
    }

    public static EmailQuery mailbox(String mailboxId) {
        Preconditions.checkNotNull((Object)mailboxId);
        return EmailQuery.of((Filter)EmailFilterCondition.builder().inMailbox(mailboxId).build(), (Comparator[])SORT_DEFAULT, (boolean)true);
    }

    public static EmailQuery keyword(String keyword, String[] trashAndJunk) {
        Preconditions.checkNotNull((Object)keyword);
        Preconditions.checkNotNull((Object)trashAndJunk);
        Preconditions.checkArgument((trashAndJunk.length <= 2 ? 1 : 0) != 0, (Object)"Provide mailbox ids for trash and junk");
        return EmailQuery.of((Filter)EmailFilterCondition.builder().hasKeyword(keyword).inMailboxOtherThan(trashAndJunk).build(), (Comparator[])SORT_DEFAULT, (boolean)true);
    }

    public static EmailQuery search(String searchTerm, String[] trashAndJunk) {
        Preconditions.checkNotNull((Object)searchTerm);
        Preconditions.checkNotNull((Object)trashAndJunk);
        Preconditions.checkArgument((trashAndJunk.length <= 2 ? 1 : 0) != 0, (Object)"Provide mailbox ids for trash and junk");
        return EmailQuery.of((Filter)EmailFilterCondition.builder().text(searchTerm).inMailboxOtherThan(trashAndJunk).build(), (Comparator[])SORT_DEFAULT, (boolean)true);
    }

    public static EmailQuery contact(String contact, String[] trashAndJunk) {
        Preconditions.checkNotNull((Object)contact);
        Preconditions.checkNotNull((Object)trashAndJunk);
        Preconditions.checkArgument((trashAndJunk.length <= 2 ? 1 : 0) != 0, (Object)"Provide mailbox ids for trash and junk");
        return EmailQuery.of((Filter)FilterOperator.and((Filter[])new Filter[]{FilterOperator.or((Filter[])new Filter[]{EmailFilterCondition.builder().from(contact).build(), EmailFilterCondition.builder().to(contact).build(), EmailFilterCondition.builder().cc(contact).build(), EmailFilterCondition.builder().bcc(contact).build()}), EmailFilterCondition.builder().inMailboxOtherThan(trashAndJunk).build()}), (Comparator[])SORT_DEFAULT, (boolean)true);
    }
}

