/*
 * Decompiled with CFR 0.152.
 */
package rs.ltt.jmap.mua.util;

import com.google.common.util.concurrent.AsyncCallable;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import rs.ltt.jmap.client.JmapClient;
import rs.ltt.jmap.client.JmapRequest;
import rs.ltt.jmap.client.MethodResponses;
import rs.ltt.jmap.common.entity.Email;
import rs.ltt.jmap.common.method.MethodCall;
import rs.ltt.jmap.common.method.MethodResponse;
import rs.ltt.jmap.common.method.call.email.ChangesEmailMethodCall;
import rs.ltt.jmap.common.method.call.email.GetEmailMethodCall;
import rs.ltt.jmap.common.method.call.identity.ChangesIdentityMethodCall;
import rs.ltt.jmap.common.method.call.identity.GetIdentityMethodCall;
import rs.ltt.jmap.common.method.call.mailbox.ChangesMailboxMethodCall;
import rs.ltt.jmap.common.method.call.mailbox.GetMailboxMethodCall;
import rs.ltt.jmap.common.method.call.thread.ChangesThreadMethodCall;
import rs.ltt.jmap.common.method.call.thread.GetThreadMethodCall;

public class UpdateUtil {
    public static MethodResponsesFuture emails(JmapClient.MultiCall multiCall, String accountId, String state) {
        JmapRequest.Call changesCallInfo = multiCall.call((MethodCall)ChangesEmailMethodCall.builder().accountId(accountId).sinceState(state).build());
        ListenableFuture changes = changesCallInfo.getMethodResponses();
        ListenableFuture created = multiCall.call((MethodCall)GetEmailMethodCall.builder().accountId(accountId).idsReference(changesCallInfo.createResultReference("/created")).properties(Email.Properties.LTTRS_DEFAULT).fetchTextBodyValues(Boolean.valueOf(true)).build()).getMethodResponses();
        ListenableFuture updated = multiCall.call((MethodCall)GetEmailMethodCall.builder().accountId(accountId).idsReference(changesCallInfo.createResultReference("/updated")).properties(Email.Properties.MUTABLE).build()).getMethodResponses();
        return new MethodResponsesFuture(changes, created, updated);
    }

    public static MethodResponsesFuture identities(JmapClient.MultiCall multiCall, String accountId, String state) {
        JmapRequest.Call changesCallInfo = multiCall.call((MethodCall)ChangesIdentityMethodCall.builder().accountId(accountId).sinceState(state).build());
        ListenableFuture changes = changesCallInfo.getMethodResponses();
        ListenableFuture created = multiCall.call((MethodCall)GetIdentityMethodCall.builder().accountId(accountId).idsReference(changesCallInfo.createResultReference("/created")).build()).getMethodResponses();
        ListenableFuture updated = multiCall.call((MethodCall)GetIdentityMethodCall.builder().accountId(accountId).idsReference(changesCallInfo.createResultReference("/updated")).build()).getMethodResponses();
        return new MethodResponsesFuture(changes, created, updated);
    }

    public static MethodResponsesFuture mailboxes(JmapClient.MultiCall multiCall, String accountId, String state) {
        JmapRequest.Call changesCallInfo = multiCall.call((MethodCall)ChangesMailboxMethodCall.builder().accountId(accountId).sinceState(state).build());
        ListenableFuture changes = changesCallInfo.getMethodResponses();
        ListenableFuture created = multiCall.call((MethodCall)GetMailboxMethodCall.builder().accountId(accountId).idsReference(changesCallInfo.createResultReference("/created")).build()).getMethodResponses();
        ListenableFuture updated = multiCall.call((MethodCall)GetMailboxMethodCall.builder().accountId(accountId).idsReference(changesCallInfo.createResultReference("/updated")).propertiesReference(changesCallInfo.createResultReference("/updatedProperties")).build()).getMethodResponses();
        return new MethodResponsesFuture(changes, created, updated);
    }

    public static MethodResponsesFuture threads(JmapClient.MultiCall multiCall, String accountId, String state) {
        JmapRequest.Call changesCallInfo = multiCall.call((MethodCall)ChangesThreadMethodCall.builder().accountId(accountId).sinceState(state).build());
        ListenableFuture changes = changesCallInfo.getMethodResponses();
        ListenableFuture created = multiCall.call((MethodCall)GetThreadMethodCall.builder().accountId(accountId).idsReference(changesCallInfo.createResultReference("/created")).build()).getMethodResponses();
        ListenableFuture updated = multiCall.call((MethodCall)GetThreadMethodCall.builder().accountId(accountId).idsReference(changesCallInfo.createResultReference("/updated")).build()).getMethodResponses();
        return new MethodResponsesFuture(changes, created, updated);
    }

    public static class MethodResponsesFuture {
        private final ListenableFuture<MethodResponses> changes;
        private final ListenableFuture<MethodResponses> created;
        private final ListenableFuture<MethodResponses> updated;

        private MethodResponsesFuture(ListenableFuture<MethodResponses> changes, ListenableFuture<MethodResponses> created, ListenableFuture<MethodResponses> updated) {
            this.changes = changes;
            this.created = created;
            this.updated = updated;
        }

        public <T extends MethodResponse> T changes(Class<T> clazz) throws ExecutionException, InterruptedException {
            return (T)((MethodResponses)this.changes.get()).getMain(clazz);
        }

        public <T extends MethodResponse> T created(Class<T> clazz) throws ExecutionException, InterruptedException {
            return (T)((MethodResponses)this.created.get()).getMain(clazz);
        }

        public <T extends MethodResponse> T updated(Class<T> clazz) throws ExecutionException, InterruptedException {
            return (T)((MethodResponses)this.updated.get()).getMain(clazz);
        }

        public <T> ListenableFuture<T> addCallback(AsyncCallable<T> callable, Executor executor) {
            return Futures.whenAllComplete((ListenableFuture[])new ListenableFuture[]{this.changes, this.created, this.updated}).callAsync(callable, executor);
        }

        public void addChangesCallback(FutureCallback<MethodResponses> callback, Executor executor) {
            Futures.addCallback(this.changes, callback, (Executor)executor);
        }
    }
}

