/*
 * Decompiled with CFR 0.152.
 */
package com.polites.android;

import com.polites.android.Animation;
import com.polites.android.FlingAnimationListener;
import com.polites.android.GestureImageView;

public class FlingAnimation
implements Animation {
    private float velocityX;
    private float velocityY;
    private float factor = 0.95f;
    private float threshold = 10.0f;
    private FlingAnimationListener listener;

    @Override
    public boolean update(GestureImageView view, long time) {
        boolean active;
        float seconds = (float)time / 1000.0f;
        float dx = this.velocityX * seconds;
        float dy = this.velocityY * seconds;
        this.velocityX *= this.factor;
        this.velocityY *= this.factor;
        boolean bl = active = Math.abs(this.velocityX) > this.threshold && Math.abs(this.velocityY) > this.threshold;
        if (this.listener != null) {
            this.listener.onMove(dx, dy);
            if (!active) {
                this.listener.onComplete();
            }
        }
        return active;
    }

    public void setVelocityX(float velocityX) {
        this.velocityX = velocityX;
    }

    public void setVelocityY(float velocityY) {
        this.velocityY = velocityY;
    }

    public void setFactor(float factor) {
        this.factor = factor;
    }

    public void setListener(FlingAnimationListener listener) {
        this.listener = listener;
    }
}

