/*
 * Decompiled with CFR 0.152.
 */
package com.polites.android;

import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import com.polites.android.Animation;
import com.polites.android.Animator;
import com.polites.android.GestureImageViewListener;
import com.polites.android.GestureImageViewTouchListener;
import java.io.InputStream;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class GestureImageView
extends ImageView {
    public static final String GLOBAL_NS = "http://schemas.android.com/apk/res/android";
    public static final String LOCAL_NS = "http://schemas.polites.com/android";
    private final Semaphore drawLock = new Semaphore(0);
    private Animator animator;
    private Drawable drawable;
    private float x = 0.0f;
    private float y = 0.0f;
    private boolean layout = false;
    private float scaleAdjust = 1.0f;
    private float startingScale = -1.0f;
    private float scale = 1.0f;
    private float maxScale = 5.0f;
    private float minScale = 0.75f;
    private float fitScaleHorizontal = 1.0f;
    private float fitScaleVertical = 1.0f;
    private float rotation = 0.0f;
    private float centerX;
    private float centerY;
    private Float startX;
    private Float startY;
    private int hWidth;
    private int hHeight;
    private int resId = -1;
    private boolean recycle = false;
    private boolean strict = false;
    private int displayHeight;
    private int displayWidth;
    private int alpha = 255;
    private ColorFilter colorFilter;
    private int deviceOrientation = -1;
    private int imageOrientation;
    private GestureImageViewListener gestureImageViewListener;
    private GestureImageViewTouchListener gestureImageViewTouchListener;
    private View.OnTouchListener customOnTouchListener;
    private View.OnClickListener onClickListener;

    public GestureImageView(Context context, AttributeSet attrs, int defStyle) {
        this(context, attrs);
    }

    public GestureImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        String scaleType = attrs.getAttributeValue(GLOBAL_NS, "scaleType");
        if (scaleType == null || scaleType.trim().length() == 0) {
            this.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        }
        String strStartX = attrs.getAttributeValue(LOCAL_NS, "start-x");
        String strStartY = attrs.getAttributeValue(LOCAL_NS, "start-y");
        if (strStartX != null && strStartX.trim().length() > 0) {
            this.startX = Float.valueOf(Float.parseFloat(strStartX));
        }
        if (strStartY != null && strStartY.trim().length() > 0) {
            this.startY = Float.valueOf(Float.parseFloat(strStartY));
        }
        this.setStartingScale(attrs.getAttributeFloatValue(LOCAL_NS, "start-scale", this.startingScale));
        this.setMinScale(attrs.getAttributeFloatValue(LOCAL_NS, "min-scale", this.minScale));
        this.setMaxScale(attrs.getAttributeFloatValue(LOCAL_NS, "max-scale", this.maxScale));
        this.setStrict(attrs.getAttributeBooleanValue(LOCAL_NS, "strict", this.strict));
        this.setRecycle(attrs.getAttributeBooleanValue(LOCAL_NS, "recycle", this.recycle));
        this.initImage();
    }

    public GestureImageView(Context context) {
        super(context);
        this.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        this.initImage();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.drawable != null) {
            int orientation = this.getResources().getConfiguration().orientation;
            if (orientation == 2) {
                this.displayHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
                if (this.getLayoutParams().width == -2) {
                    float ratio = (float)this.getImageWidth() / (float)this.getImageHeight();
                    this.displayWidth = Math.round((float)this.displayHeight * ratio);
                } else {
                    this.displayWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
                }
            } else {
                this.displayWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
                if (this.getLayoutParams().height == -2) {
                    float ratio = (float)this.getImageHeight() / (float)this.getImageWidth();
                    this.displayHeight = Math.round((float)this.displayWidth * ratio);
                } else {
                    this.displayHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
                }
            }
        } else {
            this.displayHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
            this.displayWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        }
        this.setMeasuredDimension(this.displayWidth, this.displayHeight);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (changed || !this.layout) {
            this.setupCanvas(this.displayWidth, this.displayHeight, this.getResources().getConfiguration().orientation);
        }
    }

    protected void setupCanvas(int measuredWidth, int measuredHeight, int orientation) {
        if (this.deviceOrientation != orientation) {
            this.layout = false;
            this.deviceOrientation = orientation;
        }
        if (this.drawable != null && !this.layout) {
            int imageWidth = this.getImageWidth();
            int imageHeight = this.getImageHeight();
            this.hWidth = Math.round((float)imageWidth / 2.0f);
            this.hHeight = Math.round((float)imageHeight / 2.0f);
            this.computeCropScale(imageWidth, imageHeight, measuredWidth -= this.getPaddingLeft() + this.getPaddingRight(), measuredHeight -= this.getPaddingTop() + this.getPaddingBottom());
            if (this.startingScale <= 0.0f) {
                this.computeStartingScale(imageWidth, imageHeight, measuredWidth, measuredHeight);
            }
            this.scaleAdjust = this.startingScale;
            this.centerX = (float)measuredWidth / 2.0f;
            this.centerY = (float)measuredHeight / 2.0f;
            this.x = this.startX == null ? this.centerX : this.startX.floatValue();
            this.y = this.startY == null ? this.centerY : this.startY.floatValue();
            this.gestureImageViewTouchListener = new GestureImageViewTouchListener(this, measuredWidth, measuredHeight);
            if (this.isLandscape()) {
                this.gestureImageViewTouchListener.setMinScale(this.minScale * this.fitScaleHorizontal);
            } else {
                this.gestureImageViewTouchListener.setMinScale(this.minScale * this.fitScaleVertical);
            }
            this.gestureImageViewTouchListener.setMaxScale(this.maxScale * this.startingScale);
            this.gestureImageViewTouchListener.setFitScaleHorizontal(this.fitScaleHorizontal);
            this.gestureImageViewTouchListener.setFitScaleVertical(this.fitScaleVertical);
            this.gestureImageViewTouchListener.setCanvasWidth(measuredWidth);
            this.gestureImageViewTouchListener.setCanvasHeight(measuredHeight);
            this.gestureImageViewTouchListener.setOnClickListener(this.onClickListener);
            this.drawable.setBounds(-this.hWidth, -this.hHeight, this.hWidth, this.hHeight);
            super.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    if (GestureImageView.this.customOnTouchListener != null) {
                        GestureImageView.this.customOnTouchListener.onTouch(v, event);
                    }
                    return GestureImageView.this.gestureImageViewTouchListener.onTouch(v, event);
                }
            });
            this.layout = true;
        }
    }

    protected void computeCropScale(int imageWidth, int imageHeight, int measuredWidth, int measuredHeight) {
        this.fitScaleHorizontal = (float)measuredWidth / (float)imageWidth;
        this.fitScaleVertical = (float)measuredHeight / (float)imageHeight;
    }

    protected void computeStartingScale(int imageWidth, int imageHeight, int measuredWidth, int measuredHeight) {
        switch (this.getScaleType()) {
            case CENTER: {
                this.startingScale = 1.0f;
                break;
            }
            case CENTER_CROP: {
                this.startingScale = Math.max((float)measuredHeight / (float)imageHeight, (float)measuredWidth / (float)imageWidth);
                break;
            }
            case CENTER_INSIDE: {
                float wRatio = (float)imageWidth / (float)measuredWidth;
                float hRatio = (float)imageHeight / (float)measuredHeight;
                this.startingScale = wRatio > hRatio ? this.fitScaleHorizontal : this.fitScaleVertical;
            }
        }
    }

    protected boolean isRecycled() {
        Bitmap bitmap;
        if (this.drawable != null && this.drawable instanceof BitmapDrawable && (bitmap = ((BitmapDrawable)this.drawable).getBitmap()) != null) {
            return bitmap.isRecycled();
        }
        return false;
    }

    protected void recycle() {
        Bitmap bitmap;
        if (this.recycle && this.drawable != null && this.drawable instanceof BitmapDrawable && (bitmap = ((BitmapDrawable)this.drawable).getBitmap()) != null) {
            bitmap.recycle();
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.layout) {
            if (this.drawable != null && !this.isRecycled()) {
                canvas.save();
                float adjustedScale = this.scale * this.scaleAdjust;
                canvas.translate(this.x, this.y);
                if (this.rotation != 0.0f) {
                    canvas.rotate(this.rotation);
                }
                if (adjustedScale != 1.0f) {
                    canvas.scale(adjustedScale, adjustedScale);
                }
                this.drawable.draw(canvas);
                canvas.restore();
            }
            if (this.drawLock.availablePermits() <= 0) {
                this.drawLock.release();
            }
        }
    }

    public boolean waitForDraw(long timeout) throws InterruptedException {
        return this.drawLock.tryAcquire(timeout, TimeUnit.MILLISECONDS);
    }

    protected void onAttachedToWindow() {
        this.animator = new Animator(this, "GestureImageViewAnimator");
        this.animator.start();
        if (this.resId >= 0 && this.drawable == null) {
            this.setImageResource(this.resId);
        }
        super.onAttachedToWindow();
    }

    public void animationStart(Animation animation) {
        if (this.animator != null) {
            this.animator.play(animation);
        }
    }

    public void animationStop() {
        if (this.animator != null) {
            this.animator.cancel();
        }
    }

    protected void onDetachedFromWindow() {
        if (this.animator != null) {
            this.animator.finish();
        }
        if (this.recycle && this.drawable != null && !this.isRecycled()) {
            this.recycle();
            this.drawable = null;
        }
        super.onDetachedFromWindow();
    }

    protected void initImage() {
        if (this.drawable != null) {
            this.drawable.setAlpha(this.alpha);
            this.drawable.setFilterBitmap(true);
            if (this.colorFilter != null) {
                this.drawable.setColorFilter(this.colorFilter);
            }
        }
        if (!this.layout) {
            this.requestLayout();
            this.redraw();
        }
    }

    public void setImageBitmap(Bitmap image) {
        this.drawable = new BitmapDrawable(this.getResources(), image);
        this.initImage();
    }

    public void setImageDrawable(Drawable drawable) {
        this.drawable = drawable;
        this.initImage();
    }

    public void setImageResource(int id) {
        if (this.drawable != null) {
            this.recycle();
        }
        if (id >= 0) {
            this.resId = id;
            this.setImageDrawable(this.getContext().getResources().getDrawable(id));
        }
    }

    public int getScaledWidth() {
        return Math.round((float)this.getImageWidth() * this.getScale());
    }

    public int getScaledHeight() {
        return Math.round((float)this.getImageHeight() * this.getScale());
    }

    public int getImageWidth() {
        if (this.drawable != null) {
            return this.drawable.getIntrinsicWidth();
        }
        return 0;
    }

    public int getImageHeight() {
        if (this.drawable != null) {
            return this.drawable.getIntrinsicHeight();
        }
        return 0;
    }

    public void moveBy(float x, float y) {
        this.x += x;
        this.y += y;
    }

    public void setPosition(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void redraw() {
        this.postInvalidate();
    }

    public void setMinScale(float min) {
        this.minScale = min;
        if (this.gestureImageViewTouchListener != null) {
            this.gestureImageViewTouchListener.setMinScale(min * this.fitScaleHorizontal);
        }
    }

    public void setMaxScale(float max) {
        this.maxScale = max;
        if (this.gestureImageViewTouchListener != null) {
            this.gestureImageViewTouchListener.setMaxScale(max * this.startingScale);
        }
    }

    public void setScale(float scale) {
        this.scaleAdjust = scale;
    }

    public float getScale() {
        return this.scaleAdjust;
    }

    public float getImageX() {
        return this.x;
    }

    public float getImageY() {
        return this.y;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public boolean isRecycle() {
        return this.recycle;
    }

    public void setRecycle(boolean recycle) {
        this.recycle = recycle;
    }

    public void reset() {
        this.x = this.centerX;
        this.y = this.centerY;
        this.scaleAdjust = this.startingScale;
        if (this.gestureImageViewTouchListener != null) {
            this.gestureImageViewTouchListener.reset();
        }
        this.redraw();
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
    }

    public void setGestureImageViewListener(GestureImageViewListener pinchImageViewListener) {
        this.gestureImageViewListener = pinchImageViewListener;
    }

    public GestureImageViewListener getGestureImageViewListener() {
        return this.gestureImageViewListener;
    }

    public Drawable getDrawable() {
        return this.drawable;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
        if (this.drawable != null) {
            this.drawable.setAlpha(alpha);
        }
    }

    public void setColorFilter(ColorFilter cf) {
        this.colorFilter = cf;
        if (this.drawable != null) {
            this.drawable.setColorFilter(cf);
        }
    }

    public void setImageURI(Uri mUri) {
        if ("content".equals(mUri.getScheme())) {
            try {
                String[] orientationColumn = new String[]{"orientation"};
                Cursor cur = this.getContext().getContentResolver().query(mUri, orientationColumn, null, null, null);
                if (cur != null && cur.moveToFirst()) {
                    this.imageOrientation = cur.getInt(cur.getColumnIndex(orientationColumn[0]));
                }
                InputStream in = null;
                try {
                    in = this.getContext().getContentResolver().openInputStream(mUri);
                    Bitmap bmp = BitmapFactory.decodeStream((InputStream)in);
                    if (this.imageOrientation != 0) {
                        Matrix m = new Matrix();
                        m.postRotate((float)this.imageOrientation);
                        Bitmap rotated = Bitmap.createBitmap((Bitmap)bmp, (int)0, (int)0, (int)bmp.getWidth(), (int)bmp.getHeight(), (Matrix)m, (boolean)true);
                        bmp.recycle();
                        this.setImageDrawable((Drawable)new BitmapDrawable(this.getResources(), rotated));
                    } else {
                        this.setImageDrawable((Drawable)new BitmapDrawable(this.getResources(), bmp));
                    }
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                    if (cur != null) {
                        cur.close();
                    }
                }
            }
            catch (Exception e) {
                Log.w((String)"GestureImageView", (String)("Unable to open content: " + mUri), (Throwable)e);
            }
        } else {
            this.setImageDrawable(Drawable.createFromPath((String)mUri.toString()));
        }
        if (this.drawable == null) {
            Log.e((String)"GestureImageView", (String)("resolveUri failed on bad bitmap uri: " + mUri));
            mUri = null;
        }
    }

    public Matrix getImageMatrix() {
        if (this.strict) {
            throw new UnsupportedOperationException("Not supported");
        }
        return super.getImageMatrix();
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        if (scaleType == ImageView.ScaleType.CENTER || scaleType == ImageView.ScaleType.CENTER_CROP || scaleType == ImageView.ScaleType.CENTER_INSIDE) {
            super.setScaleType(scaleType);
        } else if (this.strict) {
            throw new UnsupportedOperationException("Not supported");
        }
    }

    public void invalidateDrawable(Drawable dr) {
        if (this.strict) {
            throw new UnsupportedOperationException("Not supported");
        }
        super.invalidateDrawable(dr);
    }

    public int[] onCreateDrawableState(int extraSpace) {
        if (this.strict) {
            throw new UnsupportedOperationException("Not supported");
        }
        return super.onCreateDrawableState(extraSpace);
    }

    public void setAdjustViewBounds(boolean adjustViewBounds) {
        if (this.strict) {
            throw new UnsupportedOperationException("Not supported");
        }
        super.setAdjustViewBounds(adjustViewBounds);
    }

    public void setImageLevel(int level) {
        if (this.strict) {
            throw new UnsupportedOperationException("Not supported");
        }
        super.setImageLevel(level);
    }

    public void setImageMatrix(Matrix matrix) {
        if (this.strict) {
            throw new UnsupportedOperationException("Not supported");
        }
    }

    public void setImageState(int[] state, boolean merge) {
        if (this.strict) {
            throw new UnsupportedOperationException("Not supported");
        }
    }

    public void setSelected(boolean selected) {
        if (this.strict) {
            throw new UnsupportedOperationException("Not supported");
        }
        super.setSelected(selected);
    }

    public void setOnTouchListener(View.OnTouchListener l) {
        this.customOnTouchListener = l;
    }

    public float getCenterX() {
        return this.centerX;
    }

    public float getCenterY() {
        return this.centerY;
    }

    public boolean isLandscape() {
        return this.getImageWidth() >= this.getImageHeight();
    }

    public boolean isPortrait() {
        return this.getImageWidth() <= this.getImageHeight();
    }

    public void setStartingScale(float startingScale) {
        this.startingScale = startingScale;
    }

    public void setStartingPosition(float x, float y) {
        this.startX = Float.valueOf(x);
        this.startY = Float.valueOf(y);
    }

    public void setOnClickListener(View.OnClickListener l) {
        this.onClickListener = l;
        if (this.gestureImageViewTouchListener != null) {
            this.gestureImageViewTouchListener.setOnClickListener(l);
        }
    }

    public boolean isOrientationAligned() {
        if (this.deviceOrientation == 2) {
            return this.isLandscape();
        }
        if (this.deviceOrientation == 1) {
            return this.isPortrait();
        }
        return true;
    }

    public int getDeviceOrientation() {
        return this.deviceOrientation;
    }
}

