/*
 * Decompiled with CFR 0.152.
 */
package com.polites.android;

import android.graphics.PointF;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.polites.android.FlingAnimation;
import com.polites.android.FlingAnimationListener;
import com.polites.android.FlingListener;
import com.polites.android.GestureImageView;
import com.polites.android.GestureImageViewListener;
import com.polites.android.MathUtils;
import com.polites.android.MoveAnimation;
import com.polites.android.MoveAnimationListener;
import com.polites.android.VectorF;
import com.polites.android.ZoomAnimation;
import com.polites.android.ZoomAnimationListener;

public class GestureImageViewTouchListener
implements View.OnTouchListener {
    private GestureImageView image;
    private View.OnClickListener onClickListener;
    private final PointF current = new PointF();
    private final PointF last = new PointF();
    private final PointF next = new PointF();
    private final PointF midpoint = new PointF();
    private final VectorF scaleVector = new VectorF();
    private final VectorF pinchVector = new VectorF();
    private boolean touched = false;
    private boolean inZoom = false;
    private float initialDistance;
    private float lastScale = 1.0f;
    private float currentScale = 1.0f;
    private float boundaryLeft = 0.0f;
    private float boundaryTop = 0.0f;
    private float boundaryRight = 0.0f;
    private float boundaryBottom = 0.0f;
    private float maxScale = 5.0f;
    private float minScale = 0.25f;
    private float fitScaleHorizontal = 1.0f;
    private float fitScaleVertical = 1.0f;
    private int canvasWidth = 0;
    private int canvasHeight = 0;
    private float centerX = 0.0f;
    private float centerY = 0.0f;
    private float startingScale = 0.0f;
    private boolean canDragX = false;
    private boolean canDragY = false;
    private boolean multiTouch = false;
    private int displayWidth;
    private int displayHeight;
    private int imageWidth;
    private int imageHeight;
    private FlingListener flingListener;
    private FlingAnimation flingAnimation;
    private ZoomAnimation zoomAnimation;
    private MoveAnimation moveAnimation;
    private GestureDetector tapDetector;
    private GestureDetector flingDetector;
    private GestureImageViewListener imageListener;

    public GestureImageViewTouchListener(final GestureImageView image, int displayWidth, int displayHeight) {
        this.image = image;
        this.displayWidth = displayWidth;
        this.displayHeight = displayHeight;
        this.centerX = (float)displayWidth / 2.0f;
        this.centerY = (float)displayHeight / 2.0f;
        this.imageWidth = image.getImageWidth();
        this.imageHeight = image.getImageHeight();
        this.currentScale = this.startingScale = image.getScale();
        this.lastScale = this.startingScale;
        this.boundaryRight = displayWidth;
        this.boundaryBottom = displayHeight;
        this.boundaryLeft = 0.0f;
        this.boundaryTop = 0.0f;
        this.next.x = image.getImageX();
        this.next.y = image.getImageY();
        this.flingListener = new FlingListener();
        this.flingAnimation = new FlingAnimation();
        this.zoomAnimation = new ZoomAnimation();
        this.moveAnimation = new MoveAnimation();
        this.flingAnimation.setListener(new FlingAnimationListener(){

            @Override
            public void onMove(float x, float y) {
                GestureImageViewTouchListener.this.handleDrag(((GestureImageViewTouchListener)GestureImageViewTouchListener.this).current.x + x, ((GestureImageViewTouchListener)GestureImageViewTouchListener.this).current.y + y);
            }

            @Override
            public void onComplete() {
            }
        });
        this.zoomAnimation.setZoom(2.0f);
        this.zoomAnimation.setZoomAnimationListener(new ZoomAnimationListener(){

            @Override
            public void onZoom(float scale, float x, float y) {
                if (scale <= GestureImageViewTouchListener.this.maxScale && scale >= GestureImageViewTouchListener.this.minScale) {
                    GestureImageViewTouchListener.this.handleScale(scale, x, y);
                }
            }

            @Override
            public void onComplete() {
                GestureImageViewTouchListener.this.inZoom = false;
                GestureImageViewTouchListener.this.handleUp();
            }
        });
        this.moveAnimation.setMoveAnimationListener(new MoveAnimationListener(){

            @Override
            public void onMove(float x, float y) {
                image.setPosition(x, y);
                image.redraw();
            }
        });
        this.tapDetector = new GestureDetector(image.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onDoubleTap(MotionEvent e) {
                GestureImageViewTouchListener.this.startZoom(e);
                return true;
            }

            public boolean onSingleTapConfirmed(MotionEvent e) {
                if (!GestureImageViewTouchListener.this.inZoom && GestureImageViewTouchListener.this.onClickListener != null) {
                    GestureImageViewTouchListener.this.onClickListener.onClick((View)image);
                    return true;
                }
                return false;
            }
        });
        this.flingDetector = new GestureDetector(image.getContext(), (GestureDetector.OnGestureListener)this.flingListener);
        this.imageListener = image.getGestureImageViewListener();
        this.calculateBoundaries();
    }

    private void startFling() {
        this.flingAnimation.setVelocityX(this.flingListener.getVelocityX());
        this.flingAnimation.setVelocityY(this.flingListener.getVelocityY());
        this.image.animationStart(this.flingAnimation);
    }

    private void startZoom(MotionEvent e) {
        float zoomTo;
        this.inZoom = true;
        this.zoomAnimation.reset();
        if (this.image.isLandscape()) {
            if (this.image.getDeviceOrientation() == 1) {
                int scaledHeight = this.image.getScaledHeight();
                if (scaledHeight < this.canvasHeight) {
                    zoomTo = this.fitScaleVertical / this.currentScale;
                    this.zoomAnimation.setTouchX(e.getX());
                    this.zoomAnimation.setTouchY(this.image.getCenterY());
                } else {
                    zoomTo = this.fitScaleHorizontal / this.currentScale;
                    this.zoomAnimation.setTouchX(this.image.getCenterX());
                    this.zoomAnimation.setTouchY(this.image.getCenterY());
                }
            } else {
                int scaledWidth = this.image.getScaledWidth();
                if (scaledWidth == this.canvasWidth) {
                    zoomTo = this.currentScale * 4.0f;
                    this.zoomAnimation.setTouchX(e.getX());
                    this.zoomAnimation.setTouchY(e.getY());
                } else if (scaledWidth < this.canvasWidth) {
                    zoomTo = this.fitScaleHorizontal / this.currentScale;
                    this.zoomAnimation.setTouchX(this.image.getCenterX());
                    this.zoomAnimation.setTouchY(e.getY());
                } else {
                    zoomTo = this.fitScaleHorizontal / this.currentScale;
                    this.zoomAnimation.setTouchX(this.image.getCenterX());
                    this.zoomAnimation.setTouchY(this.image.getCenterY());
                }
            }
        } else if (this.image.getDeviceOrientation() == 1) {
            int scaledHeight = this.image.getScaledHeight();
            if (scaledHeight == this.canvasHeight) {
                zoomTo = this.currentScale * 4.0f;
                this.zoomAnimation.setTouchX(e.getX());
                this.zoomAnimation.setTouchY(e.getY());
            } else if (scaledHeight < this.canvasHeight) {
                zoomTo = this.fitScaleVertical / this.currentScale;
                this.zoomAnimation.setTouchX(e.getX());
                this.zoomAnimation.setTouchY(this.image.getCenterY());
            } else {
                zoomTo = this.fitScaleVertical / this.currentScale;
                this.zoomAnimation.setTouchX(this.image.getCenterX());
                this.zoomAnimation.setTouchY(this.image.getCenterY());
            }
        } else {
            int scaledWidth = this.image.getScaledWidth();
            if (scaledWidth < this.canvasWidth) {
                zoomTo = this.fitScaleHorizontal / this.currentScale;
                this.zoomAnimation.setTouchX(this.image.getCenterX());
                this.zoomAnimation.setTouchY(e.getY());
            } else {
                zoomTo = this.fitScaleVertical / this.currentScale;
                this.zoomAnimation.setTouchX(this.image.getCenterX());
                this.zoomAnimation.setTouchY(this.image.getCenterY());
            }
        }
        this.zoomAnimation.setZoom(zoomTo);
        this.image.animationStart(this.zoomAnimation);
    }

    private void stopAnimations() {
        this.image.animationStop();
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (!this.inZoom && !this.tapDetector.onTouchEvent(event)) {
            if (event.getPointerCount() == 1 && this.flingDetector.onTouchEvent(event)) {
                this.startFling();
            }
            if (event.getAction() == 1) {
                this.handleUp();
            } else if (event.getAction() == 0) {
                this.stopAnimations();
                this.last.x = event.getX();
                this.last.y = event.getY();
                if (this.imageListener != null) {
                    this.imageListener.onTouch(this.last.x, this.last.y);
                }
                this.touched = true;
            } else if (event.getAction() == 2) {
                if (event.getPointerCount() > 1) {
                    this.multiTouch = true;
                    if (this.initialDistance > 0.0f) {
                        float newScale;
                        this.pinchVector.set(event);
                        this.pinchVector.calculateLength();
                        float distance = this.pinchVector.length;
                        if (this.initialDistance != distance && (newScale = distance / this.initialDistance * this.lastScale) <= this.maxScale) {
                            this.scaleVector.length *= newScale;
                            this.scaleVector.calculateEndPoint();
                            this.scaleVector.length /= newScale;
                            float newX = this.scaleVector.end.x;
                            float newY = this.scaleVector.end.y;
                            this.handleScale(newScale, newX, newY);
                        }
                    } else {
                        this.initialDistance = MathUtils.distance(event);
                        MathUtils.midpoint(event, this.midpoint);
                        this.scaleVector.setStart(this.midpoint);
                        this.scaleVector.setEnd(this.next);
                        this.scaleVector.calculateLength();
                        this.scaleVector.calculateAngle();
                        this.scaleVector.length /= this.lastScale;
                    }
                } else if (!this.touched) {
                    this.touched = true;
                    this.last.x = event.getX();
                    this.last.y = event.getY();
                    this.next.x = this.image.getImageX();
                    this.next.y = this.image.getImageY();
                } else if (!this.multiTouch && this.handleDrag(event.getX(), event.getY())) {
                    this.image.redraw();
                }
            }
        }
        return true;
    }

    protected void handleUp() {
        this.multiTouch = false;
        this.initialDistance = 0.0f;
        this.lastScale = this.currentScale;
        if (!this.canDragX) {
            this.next.x = this.centerX;
        }
        if (!this.canDragY) {
            this.next.y = this.centerY;
        }
        this.boundCoordinates();
        if (!this.canDragX && !this.canDragY) {
            if (this.image.isLandscape()) {
                this.currentScale = this.fitScaleHorizontal;
                this.lastScale = this.fitScaleHorizontal;
            } else {
                this.currentScale = this.fitScaleVertical;
                this.lastScale = this.fitScaleVertical;
            }
        }
        this.image.setScale(this.currentScale);
        this.image.setPosition(this.next.x, this.next.y);
        if (this.imageListener != null) {
            this.imageListener.onScale(this.currentScale);
            this.imageListener.onPosition(this.next.x, this.next.y);
        }
        this.image.redraw();
    }

    protected void handleScale(float scale, float x, float y) {
        this.currentScale = scale;
        if (this.currentScale > this.maxScale) {
            this.currentScale = this.maxScale;
        } else if (this.currentScale < this.minScale) {
            this.currentScale = this.minScale;
        } else {
            this.next.x = x;
            this.next.y = y;
        }
        this.calculateBoundaries();
        this.image.setScale(this.currentScale);
        this.image.setPosition(this.next.x, this.next.y);
        if (this.imageListener != null) {
            this.imageListener.onScale(this.currentScale);
            this.imageListener.onPosition(this.next.x, this.next.y);
        }
        this.image.redraw();
    }

    protected boolean handleDrag(float x, float y) {
        this.current.x = x;
        this.current.y = y;
        float diffX = this.current.x - this.last.x;
        float diffY = this.current.y - this.last.y;
        if (diffX != 0.0f || diffY != 0.0f) {
            if (this.canDragX) {
                this.next.x += diffX;
            }
            if (this.canDragY) {
                this.next.y += diffY;
            }
            this.boundCoordinates();
            this.last.x = this.current.x;
            this.last.y = this.current.y;
            if (this.canDragX || this.canDragY) {
                this.image.setPosition(this.next.x, this.next.y);
                if (this.imageListener != null) {
                    this.imageListener.onPosition(this.next.x, this.next.y);
                }
                return true;
            }
        }
        return false;
    }

    public void reset() {
        this.currentScale = this.startingScale;
        this.next.x = this.centerX;
        this.next.y = this.centerY;
        this.calculateBoundaries();
        this.image.setScale(this.currentScale);
        this.image.setPosition(this.next.x, this.next.y);
        this.image.redraw();
    }

    public float getMaxScale() {
        return this.maxScale;
    }

    public void setMaxScale(float maxScale) {
        this.maxScale = maxScale;
    }

    public float getMinScale() {
        return this.minScale;
    }

    public void setMinScale(float minScale) {
        this.minScale = minScale;
    }

    public void setOnClickListener(View.OnClickListener onClickListener) {
        this.onClickListener = onClickListener;
    }

    protected void setCanvasWidth(int canvasWidth) {
        this.canvasWidth = canvasWidth;
    }

    protected void setCanvasHeight(int canvasHeight) {
        this.canvasHeight = canvasHeight;
    }

    protected void setFitScaleHorizontal(float fitScale) {
        this.fitScaleHorizontal = fitScale;
    }

    protected void setFitScaleVertical(float fitScaleVertical) {
        this.fitScaleVertical = fitScaleVertical;
    }

    protected void boundCoordinates() {
        if (this.next.x < this.boundaryLeft) {
            this.next.x = this.boundaryLeft;
        } else if (this.next.x > this.boundaryRight) {
            this.next.x = this.boundaryRight;
        }
        if (this.next.y < this.boundaryTop) {
            this.next.y = this.boundaryTop;
        } else if (this.next.y > this.boundaryBottom) {
            this.next.y = this.boundaryBottom;
        }
    }

    protected void calculateBoundaries() {
        float diff;
        int effectiveWidth = Math.round((float)this.imageWidth * this.currentScale);
        int effectiveHeight = Math.round((float)this.imageHeight * this.currentScale);
        this.canDragX = effectiveWidth > this.displayWidth;
        boolean bl = this.canDragY = effectiveHeight > this.displayHeight;
        if (this.canDragX) {
            diff = (float)(effectiveWidth - this.displayWidth) / 2.0f;
            this.boundaryLeft = this.centerX - diff;
            this.boundaryRight = this.centerX + diff;
        }
        if (this.canDragY) {
            diff = (float)(effectiveHeight - this.displayHeight) / 2.0f;
            this.boundaryTop = this.centerY - diff;
            this.boundaryBottom = this.centerY + diff;
        }
    }
}

