/*
 * Decompiled with CFR 0.152.
 */
package com.polites.android;

import android.graphics.PointF;
import android.util.FloatMath;
import android.view.MotionEvent;

public class MathUtils {
    public static float distance(MotionEvent event) {
        float x = event.getX(0) - event.getX(1);
        float y = event.getY(0) - event.getY(1);
        return FloatMath.sqrt((float)(x * x + y * y));
    }

    public static float distance(PointF p1, PointF p2) {
        float x = p1.x - p2.x;
        float y = p1.y - p2.y;
        return FloatMath.sqrt((float)(x * x + y * y));
    }

    public static float distance(float x1, float y1, float x2, float y2) {
        float x = x1 - x2;
        float y = y1 - y2;
        return FloatMath.sqrt((float)(x * x + y * y));
    }

    public static void midpoint(MotionEvent event, PointF point) {
        float x1 = event.getX(0);
        float y1 = event.getY(0);
        float x2 = event.getX(1);
        float y2 = event.getY(1);
        MathUtils.midpoint(x1, y1, x2, y2, point);
    }

    public static void midpoint(float x1, float y1, float x2, float y2, PointF point) {
        point.x = (x1 + x2) / 2.0f;
        point.y = (y1 + y2) / 2.0f;
    }

    public void rotate(PointF p1, PointF p2, float angle) {
        float px = p1.x;
        float py = p1.y;
        float ox = p2.x;
        float oy = p2.y;
        p1.x = FloatMath.cos((float)angle) * (px - ox) - FloatMath.sin((float)angle) * (py - oy) + ox;
        p1.y = FloatMath.sin((float)angle) * (px - ox) + FloatMath.cos((float)angle) * (py - oy) + oy;
    }

    public static float angle(PointF p1, PointF p2) {
        return MathUtils.angle(p1.x, p1.y, p2.x, p2.y);
    }

    public static float angle(float x1, float y1, float x2, float y2) {
        return (float)Math.atan2(y2 - y1, x2 - x1);
    }
}

