/*
 * Decompiled with CFR 0.152.
 */
package com.polites.android;

import android.graphics.PointF;
import com.polites.android.Animation;
import com.polites.android.GestureImageView;
import com.polites.android.VectorF;
import com.polites.android.ZoomAnimationListener;

public class ZoomAnimation
implements Animation {
    private boolean firstFrame = true;
    private float touchX;
    private float touchY;
    private float zoom;
    private float startX;
    private float startY;
    private float startScale;
    private float xDiff;
    private float yDiff;
    private float scaleDiff;
    private long animationLengthMS = 200L;
    private long totalTime = 0L;
    private ZoomAnimationListener zoomAnimationListener;

    @Override
    public boolean update(GestureImageView view, long time) {
        float newScale;
        if (this.firstFrame) {
            this.firstFrame = false;
            this.startX = view.getImageX();
            this.startY = view.getImageY();
            this.startScale = view.getScale();
            this.scaleDiff = this.zoom * this.startScale - this.startScale;
            if (this.scaleDiff > 0.0f) {
                VectorF vector = new VectorF();
                vector.setStart(new PointF(this.touchX, this.touchY));
                vector.setEnd(new PointF(this.startX, this.startY));
                vector.calculateAngle();
                float length = vector.calculateLength();
                vector.length = length * this.zoom;
                vector.calculateEndPoint();
                this.xDiff = vector.end.x - this.startX;
                this.yDiff = vector.end.y - this.startY;
            } else {
                this.xDiff = view.getCenterX() - this.startX;
                this.yDiff = view.getCenterY() - this.startY;
            }
        }
        this.totalTime += time;
        float ratio = (float)this.totalTime / (float)this.animationLengthMS;
        if (ratio < 1.0f) {
            if (ratio > 0.0f) {
                newScale = ratio * this.scaleDiff + this.startScale;
                float newX = ratio * this.xDiff + this.startX;
                float newY = ratio * this.yDiff + this.startY;
                if (this.zoomAnimationListener != null) {
                    this.zoomAnimationListener.onZoom(newScale, newX, newY);
                }
            }
            return true;
        }
        newScale = this.scaleDiff + this.startScale;
        float newX = this.xDiff + this.startX;
        float newY = this.yDiff + this.startY;
        if (this.zoomAnimationListener != null) {
            this.zoomAnimationListener.onZoom(newScale, newX, newY);
            this.zoomAnimationListener.onComplete();
        }
        return false;
    }

    public void reset() {
        this.firstFrame = true;
        this.totalTime = 0L;
    }

    public float getZoom() {
        return this.zoom;
    }

    public void setZoom(float zoom) {
        this.zoom = zoom;
    }

    public float getTouchX() {
        return this.touchX;
    }

    public void setTouchX(float touchX) {
        this.touchX = touchX;
    }

    public float getTouchY() {
        return this.touchY;
    }

    public void setTouchY(float touchY) {
        this.touchY = touchY;
    }

    public long getAnimationLengthMS() {
        return this.animationLengthMS;
    }

    public void setAnimationLengthMS(long animationLengthMS) {
        this.animationLengthMS = animationLengthMS;
    }

    public ZoomAnimationListener getZoomAnimationListener() {
        return this.zoomAnimationListener;
    }

    public void setZoomAnimationListener(ZoomAnimationListener zoomAnimationListener) {
        this.zoomAnimationListener = zoomAnimationListener;
    }
}

