/*
 * Decompiled with CFR 0.152.
 */
package ru.appsm.inapphelp;

import android.app.Activity;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.NotificationCompat;
import android.util.Log;
import com.android.volley.AuthFailureError;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.toolbox.HttpStack;
import com.android.volley.toolbox.HurlStack;
import com.android.volley.toolbox.Volley;
import java.io.IOException;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.json.JSONException;
import org.json.JSONObject;
import ru.appsm.inapphelp.activities.HomeActivity;
import ru.appsm.inapphelp.activities.IssueDetailActivity;
import ru.appsm.inapphelp.gears.IAHInapphelpGear;
import ru.appsm.inapphelp.logic.IAHGear;
import ru.appsm.inapphelp.logic.IAHSource;

public class IAHHelpDesk {
    private static final String TAG = IAHHelpDesk.class.getSimpleName();
    public static final String LOG_TAG = IAHHelpDesk.class.getSimpleName();
    private static NotificationManager mNotificationManager;
    private static IAHHelpDesk singletonInstance;
    private Context mContext;
    private IAHGear gear;
    private RequestQueue mRequestQueue;
    private boolean showCredits;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Context context, String company, String app_id, String app_key) {
        assert (context != null) : "Context cannot be null";
        assert (company != null) : "Company name cannot be null";
        assert (app_id != null) : "App id cannot be null";
        assert (app_key != null) : "App key cannot be null";
        Class<IAHHelpDesk> clazz = IAHHelpDesk.class;
        synchronized (IAHHelpDesk.class) {
            if (singletonInstance == null) {
                singletonInstance = new IAHHelpDesk(context.getApplicationContext(), company, app_id, app_key);
                IAHSource iAHSource = IAHSource.getInstance(context.getApplicationContext());
            } else {
                Log.e((String)TAG, (String)"Inapphelp has been already inited");
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    public static IAHHelpDesk getInstance() {
        if (singletonInstance == null) {
            Log.e((String)TAG, (String)"Helpstack not inited");
        }
        return singletonInstance;
    }

    public static void OpenSupportForData(JSONObject data, Activity activity) {
        Log.i((String)TAG, (String)"handle push");
        if (data != null && data.has("secretkey") && data.has("userid") && data.has("appkey") && data.has("appid") && data.has("email") && data.has("message") && data.has("title") && data.has("notId") && data.has("msgId")) {
            try {
                Intent notificationIntent = new Intent(activity.getApplicationContext(), IssueDetailActivity.class);
                notificationIntent.putExtra("fromPush", true);
                notificationIntent.putExtra("userid", data.getString("userid"));
                notificationIntent.putExtra("appid", data.getString("appid"));
                notificationIntent.putExtra("appkey", data.getString("appkey"));
                notificationIntent.putExtra("secretkey", data.getString("secretkey"));
                notificationIntent.putExtra("email", data.getString("email"));
                notificationIntent.putExtra("msgId", data.getString("msgId"));
                activity.startActivity(notificationIntent);
            }
            catch (JSONException e) {
                Log.i((String)TAG, (String)"Fail to parse push data");
            }
        } else {
            Log.i((String)TAG, (String)"Empty or wrong push data");
        }
    }

    public static void HandelPushIntentWithContext(Intent intent, Context context) {
        Log.i((String)TAG, (String)"handle push");
        Bundle extras = intent.getExtras();
        if (extras != null && extras.containsKey("secretkey") && extras.containsKey("userid") && extras.containsKey("appkey") && extras.containsKey("appid") && extras.containsKey("email") && extras.containsKey("message") && extras.containsKey("title") && extras.containsKey("notId") && extras.containsKey("msgId")) {
            JSONObject data = new JSONObject();
            int notId = 1;
            try {
                notId = Integer.parseInt(extras.getString("notId"));
            }
            catch (NumberFormatException e) {
                notId = 1;
            }
            try {
                data.put("notId", notId);
                data.put("userid", (Object)extras.getString("userid"));
                data.put("appid", (Object)extras.getString("appid"));
                data.put("appkey", (Object)extras.getString("appkey"));
                data.put("secretkey", (Object)extras.getString("secretkey"));
                data.put("email", (Object)extras.getString("email"));
                data.put("title", (Object)extras.getString("title"));
                data.put("message", (Object)extras.getString("message"));
                data.put("msgId", (Object)extras.getString("msgId"));
                data.put("sound", (Object)extras.getString("sound"));
                IAHHelpDesk.BuildNotificationForDataWithContext(data, context);
            }
            catch (JSONException e) {
                Log.i((String)TAG, (String)"Fail to parse push data");
            }
        } else {
            Log.i((String)TAG, (String)"Empty or wrong push intent");
        }
    }

    public static void BuildNotificationForDataWithContext(JSONObject data, Context context) {
        Log.i((String)TAG, (String)"Create notifications");
        if (data != null && data.has("secretkey") && data.has("userid") && data.has("appkey") && data.has("appid") && data.has("email") && data.has("message") && data.has("title") && data.has("notId") && data.has("msgId")) {
            try {
                int notId = 1;
                try {
                    notId = data.getInt("notId");
                }
                catch (JSONException e) {
                    notId = 1;
                }
                mNotificationManager = (NotificationManager)context.getSystemService("notification");
                Intent notificationIntent = new Intent(context, IssueDetailActivity.class);
                notificationIntent.putExtra("fromPush", true);
                notificationIntent.putExtra("userid", data.getString("userid"));
                notificationIntent.putExtra("appid", data.getString("appid"));
                notificationIntent.putExtra("appkey", data.getString("appkey"));
                notificationIntent.putExtra("secretkey", data.getString("secretkey"));
                notificationIntent.putExtra("email", data.getString("email"));
                PendingIntent contentIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)notificationIntent, (int)0);
                NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(context).setSmallIcon(IAHHelpDesk.getApplicationIcon(context)).setContentTitle((CharSequence)data.getString("title")).setContentText((CharSequence)data.getString("message")).setAutoCancel(true).setContentIntent(contentIntent);
                if (data.getString("sound").equals("default")) {
                    mBuilder.setDefaults(7);
                }
                mNotificationManager.notify(notId, mBuilder.build());
            }
            catch (JSONException e) {
                Log.i((String)TAG, (String)"Fail to parse push data");
            }
        } else {
            Log.i((String)TAG, (String)"Empty or wrong push data");
        }
    }

    private static int getApplicationIcon(Context context) {
        int appIconResId = 0;
        appIconResId = IAHHelpDesk.getIconValue(context.getPackageName(), "ic_notify");
        if (appIconResId == -1) {
            appIconResId = context.getApplicationInfo().icon;
        }
        return appIconResId;
    }

    private static int getIconValue(String className, String iconName) {
        try {
            Class<?> clazz = Class.forName(className + ".R$drawable");
            return (Integer)clazz.getDeclaredField(iconName).get(Integer.class);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static void setUserId(String userId) {
        if (singletonInstance != null) {
            IAHSource.getInstance(IAHHelpDesk.singletonInstance.mContext).setUserId(userId);
        } else {
            Log.e((String)TAG, (String)"Fail to set user id. Inapphelp not inited");
        }
    }

    public static void setUserSecret(String userSecret) {
        if (singletonInstance != null) {
            IAHSource.getInstance(IAHHelpDesk.singletonInstance.mContext).setUserSecret(userSecret);
        } else {
            Log.e((String)TAG, (String)"Fail to set user secret. Inapphelp not inited");
        }
    }

    public static void setPushToken(String pushToken) {
        if (singletonInstance != null) {
            IAHSource.getInstance(IAHHelpDesk.singletonInstance.mContext).setPushToken(pushToken);
        } else {
            Log.e((String)TAG, (String)"Fail to set push token. Inapphelp not inited");
        }
    }

    public IAHGear getGear() {
        return this.gear;
    }

    public static void showHelp(Activity activity) {
        if (singletonInstance != null) {
            activity.startActivity(new Intent((Context)activity, HomeActivity.class));
        } else {
            Log.e((String)TAG, (String)"Inapphelp not inited");
        }
    }

    public void overrideGearArticlesWithLocalArticlePath(int articleResId) {
        assert (this.gear != null) : "Some gear has to be set before overriding gear with local article path";
        this.gear.setNotImplementingKBFetching(articleResId);
    }

    public RequestQueue getRequestQueue() {
        return this.mRequestQueue;
    }

    private IAHHelpDesk(Context context, final String company, String app_id, String app_key) {
        this.mContext = context;
        this.gear = new IAHInapphelpGear(company, app_id, app_key);
        HurlStack stack = new HurlStack(){

            public HttpResponse performRequest(Request<?> request, Map<String, String> headers) throws IOException, AuthFailureError {
                headers.put("referer", String.format("http://www.%s.inapphelp.com/", company));
                return super.performRequest(request, headers);
            }
        };
        this.mRequestQueue = Volley.newRequestQueue((Context)context, (HttpStack)stack);
    }

    static {
        singletonInstance = null;
    }
}

