/*
 * Decompiled with CFR 0.152.
 */
package ru.appsm.inapphelp.activities;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;

public class DrawingView
extends View {
    private Path mPath = new Path();
    private Paint mPaint = new Paint();
    private Canvas mCanvas;
    private Paint canvasPaint;
    private Bitmap canvasBitmap;
    private Bitmap cachedBitmap;
    private int paintColor = -769226;
    private int brushSize = 20;
    private int resizedWidth;
    private int resizedHeight;
    private boolean isEdited;
    private ObserverInterface mObserver;

    public DrawingView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mPaint.setColor(this.paintColor);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStrokeWidth((float)this.brushSize);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.canvasPaint = new Paint(4);
    }

    public void setCanvasBitmap(Bitmap bitmap) {
        this.cachedBitmap = bitmap;
        this.mCanvas.drawColor(-16777216);
        Bitmap mutableBitmap = bitmap.copy(Bitmap.Config.ARGB_8888, true);
        this.calculateResizeRatio(bitmap, this.mCanvas);
        Bitmap resizedBitmap = Bitmap.createScaledBitmap((Bitmap)mutableBitmap, (int)this.resizedWidth, (int)this.resizedHeight, (boolean)false);
        int leftStart = this.getLeftStart(this.resizedWidth);
        int topStart = this.getTopStart(this.resizedHeight);
        this.mCanvas.drawBitmap(resizedBitmap, (float)leftStart, (float)topStart, this.mPaint);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.canvasBitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.mCanvas = new Canvas(this.canvasBitmap);
    }

    protected void onDraw(Canvas canvas) {
        canvas.drawBitmap(this.canvasBitmap, 0.0f, 0.0f, this.canvasPaint);
        canvas.drawPath(this.mPath, this.mPaint);
    }

    public boolean onTouchEvent(MotionEvent event) {
        float touchX = event.getX();
        float touchY = event.getY();
        switch (event.getAction()) {
            case 0: {
                this.mPath.moveTo(touchX, touchY);
                break;
            }
            case 2: {
                this.mPath.lineTo(touchX, touchY);
                break;
            }
            case 1: {
                this.mCanvas.drawPath(this.mPath, this.mPaint);
                this.setIsEdited(true);
                this.mPath.reset();
                this.activateClearOptionInActivity(true);
                break;
            }
            default: {
                return false;
            }
        }
        this.invalidate();
        return true;
    }

    public void setColor(String newColor) {
        this.invalidate();
        this.paintColor = Color.parseColor((String)newColor);
        this.mPaint.setColor(this.paintColor);
    }

    public void clearChanges() {
        this.mPath.reset();
        this.setCanvasBitmap(this.cachedBitmap);
        this.setIsEdited(false);
        this.activateClearOptionInActivity(false);
        this.invalidate();
    }

    private void setIsEdited(boolean value) {
        this.isEdited = value;
    }

    public boolean hasBeenEdited() {
        return this.isEdited;
    }

    private void calculateResizeRatio(Bitmap bitmap, Canvas drawCanvas) {
        double resizeRatio = StrictMath.min((double)drawCanvas.getWidth() / (double)bitmap.getWidth(), (double)drawCanvas.getHeight() / (double)bitmap.getHeight());
        this.resizedWidth = (int)(resizeRatio * (double)bitmap.getWidth());
        this.resizedHeight = (int)(resizeRatio * (double)bitmap.getHeight());
    }

    private int getTopStart(int resizedHeight) {
        int topStart = this.getTop() + this.getBottom() - resizedHeight >> 1;
        return topStart;
    }

    private int getLeftStart(int resizedWidth) {
        int leftStart = this.getLeft() + this.getRight() - resizedWidth >> 1;
        return leftStart;
    }

    public void setObserver(ObserverInterface observer) {
        this.mObserver = observer;
    }

    private void activateClearOptionInActivity(boolean isEdited) {
        if (this.mObserver != null) {
            this.mObserver.activateClearOption(isEdited);
        }
    }

    public static interface ObserverInterface {
        public void activateClearOption(boolean var1);
    }
}

