/*
 * Decompiled with CFR 0.152.
 */
package ru.appsm.inapphelp.activities;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.MediaStore;
import android.support.v7.app.ActionBarActivity;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.ImageButton;
import android.widget.TextView;
import android.widget.Toast;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.UUID;
import ru.appsm.inapphelp.R;
import ru.appsm.inapphelp.activities.DrawingView;
import ru.appsm.inapphelp.activities.IAHActivityManager;
import ru.appsm.inapphelp.model.IAHAttachment;

public class EditAttachmentActivity
extends ActionBarActivity {
    private final int REQUEST_CODE_PHOTO_PICKER = 100;
    private DrawingView drawView;
    private ImageButton currentPaint;
    private IAHAttachment selectedAttachment;
    private Bitmap originalBitmap;
    private TextView clearChangesTextView;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.iah_activity_edit_attachment);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.getSupportActionBar().setTitle(R.string.iah_attachment_edit);
        this.drawView = (DrawingView)this.findViewById(R.id.drawing);
        this.drawView.setObserver(new DrawingView.ObserverInterface(){

            @Override
            public void activateClearOption(boolean isEnabled) {
                EditAttachmentActivity.this.activityClearTextView(isEnabled);
            }
        });
        TextView clearChanges = (TextView)this.findViewById(R.id.clear_change_text);
        clearChanges.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                EditAttachmentActivity.this.drawView.clearChanges();
            }
        });
        this.currentPaint = (ImageButton)this.findViewById(R.id.iah_red_brush);
        if (Build.VERSION.SDK_INT < 16) {
            this.currentPaint.setBackgroundDrawable(this.getResources().getDrawable(R.drawable.paint_pressed));
        } else {
            this.currentPaint.setBackground(this.getResources().getDrawable(R.drawable.paint_pressed));
        }
        this.clearChangesTextView = (TextView)this.findViewById(R.id.clear_change_text);
        Intent intent = new Intent();
        intent.setType("image/*");
        intent.setAction("android.intent.action.GET_CONTENT");
        this.startActivityForResult(Intent.createChooser((Intent)intent, (CharSequence)this.getResources().getString(R.string.iah_select_picture)), 100);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(R.menu.iah_edit_attachment, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == 16908332) {
            this.discardDraft();
            return true;
        }
        if (id2 == R.id.attach) {
            this.onSaveClick();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void onBackPressed() {
        this.discardDraft();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent intent) {
        super.onActivityResult(requestCode, resultCode, intent);
        switch (requestCode) {
            case 100: {
                if (resultCode == -1) {
                    Uri selectedImage = intent.getData();
                    Cursor cursor = this.getContentResolver().query(selectedImage, new String[]{"_data", "_display_name", "mime_type"}, null, null, null);
                    cursor.moveToFirst();
                    String display_name = cursor.getString(cursor.getColumnIndex("_display_name"));
                    String mime_type = cursor.getString(cursor.getColumnIndex("mime_type"));
                    cursor.close();
                    this.selectedAttachment = IAHAttachment.createAttachment(selectedImage.toString(), display_name, mime_type);
                    try {
                        Uri uri = Uri.parse((String)this.selectedAttachment.getUrl());
                        this.originalBitmap = BitmapFactory.decodeStream((InputStream)this.getContentResolver().openInputStream(uri), null, null);
                        this.drawView.setCanvasBitmap(this.originalBitmap);
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                this.finish();
            }
        }
    }

    private void onSaveClick() {
        this.drawView.setDrawingCacheEnabled(true);
        String imageSaved = this.drawView.hasBeenEdited() ? MediaStore.Images.Media.insertImage((ContentResolver)this.getContentResolver(), (Bitmap)this.drawView.getDrawingCache(), (String)(UUID.randomUUID().toString() + ".png"), (String)"drawing") : MediaStore.Images.Media.insertImage((ContentResolver)this.getContentResolver(), (Bitmap)this.originalBitmap, (String)(UUID.randomUUID().toString() + ".png"), (String)"drawing");
        if (imageSaved != null) {
            Toast savedToast = Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"Drawing saved to Gallery!", (int)0);
            savedToast.show();
            Intent resultIntent = new Intent();
            resultIntent.putExtra("URI", imageSaved);
            this.setResult(-1, resultIntent);
            this.finish();
        } else {
            Toast unsavedToast = Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"Oops! Image could not be saved.", (int)0);
            unsavedToast.show();
        }
        this.drawView.destroyDrawingCache();
    }

    public void paintColorClicked(View view) {
        if (view != this.currentPaint) {
            ImageButton imageButton = (ImageButton)view;
            String color2 = imageButton.getTag().toString();
            this.drawView.setColor(color2);
            if (Build.VERSION.SDK_INT < 16) {
                imageButton.setBackgroundDrawable(this.getResources().getDrawable(R.drawable.paint_pressed));
                this.currentPaint.setBackgroundDrawable(this.getResources().getDrawable(R.drawable.paint));
            } else {
                imageButton.setBackground(this.getResources().getDrawable(R.drawable.paint_pressed));
                this.currentPaint.setBackground(this.getResources().getDrawable(R.drawable.paint));
            }
            this.currentPaint = (ImageButton)view;
        }
    }

    private void discardDraft() {
        if (this.drawView.hasBeenEdited()) {
            new AlertDialog.Builder((Context)this).setTitle(R.string.iah_discard).setMessage((CharSequence)"Do you want to discard your changes?").setNegativeButton(17039369, null).setPositiveButton(R.string.iah_discard, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface arg0, int arg1) {
                    EditAttachmentActivity.super.onBackPressed();
                }
            }).create().show();
        } else {
            IAHActivityManager.finishSafe((Activity)this);
        }
    }

    public void activityClearTextView(boolean isEnabled) {
        if (isEnabled) {
            this.clearChangesTextView.setTextColor(this.getResources().getColor(17170443));
        } else {
            this.clearChangesTextView.setTextColor(this.getResources().getColor(R.color.iah_darkerGreycolor));
        }
    }
}

