/*
 * Decompiled with CFR 0.152.
 */
package ru.appsm.inapphelp.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import com.google.gson.Gson;
import java.io.Serializable;
import ru.appsm.inapphelp.activities.ArticleActivity;
import ru.appsm.inapphelp.activities.HomeActivity;
import ru.appsm.inapphelp.activities.ImageAttachmentDisplayActivity;
import ru.appsm.inapphelp.activities.IssueDetailActivity;
import ru.appsm.inapphelp.activities.NewIssueActivity;
import ru.appsm.inapphelp.activities.NewUserActivity;
import ru.appsm.inapphelp.activities.SectionActivity;
import ru.appsm.inapphelp.fragments.IAHFragmentParent;
import ru.appsm.inapphelp.model.IAHAttachment;
import ru.appsm.inapphelp.model.IAHKBItem;
import ru.appsm.inapphelp.model.IAHUser;

public class IAHActivityManager {
    public static final int resultCode_sucess = -1;
    public static final int resultCode_cancelled = 0;

    public static void startHomeActivity(Context context) {
        Intent intent = new Intent(context, HomeActivity.class);
        context.startActivity(intent);
    }

    public static void startNewIssueActivity(IAHFragmentParent context, IAHUser user, int requestCode) {
        Intent intent = new Intent((Context)context.getActivity(), NewIssueActivity.class);
        if (user != null) {
            intent.putExtra("user", (Serializable)user);
        }
        context.startActivityForResult(intent, requestCode);
    }

    public static void startSectionActivity(IAHFragmentParent context, IAHKBItem kbItem, int requestCode) {
        Intent intent = new Intent((Context)context.getActivity(), SectionActivity.class);
        intent.putExtra("section_item", (Serializable)kbItem);
        context.startActivityForResult(intent, requestCode);
    }

    public static void startArticleActivity(IAHFragmentParent context, IAHKBItem kbItem, int requestCode) {
        Intent intent = new Intent((Context)context.getActivity(), ArticleActivity.class);
        intent.putExtra("item", (Serializable)kbItem);
        context.startActivityForResult(intent, requestCode);
    }

    public static void startNewUserActivity(IAHFragmentParent context, int requestCode, String message, IAHAttachment[] attachmentArray) {
        Intent intent = new Intent((Context)context.getActivity(), NewUserActivity.class);
        intent.putExtra("message", message);
        if (attachmentArray != null) {
            Gson json = new Gson();
            intent.putExtra("attachment", json.toJson((Object)attachmentArray));
        }
        context.startActivityForResult(intent, requestCode);
    }

    public static void startIssueDetailActivity(Activity context, IAHUser user) {
        Intent intent = new Intent((Context)context, IssueDetailActivity.class);
        intent.putExtra("user", (Serializable)user);
        context.startActivity(intent);
    }

    public static void startImageAttachmentDisplayActivity(Activity context, String url, String title) {
        Intent intent = new Intent((Context)context, ImageAttachmentDisplayActivity.class);
        intent.putExtra("html_content", url);
        intent.putExtra("title", title);
        context.startActivity(intent);
    }

    public static void finishSafe(Activity context) {
        Intent intent = new Intent();
        context.setResult(0, intent);
        context.finish();
    }

    public static void sendSuccessSignal(Activity context, Intent result) {
        context.setResult(-1, result);
        context.finish();
    }
}

