/*
 * Decompiled with CFR 0.152.
 */
package ru.appsm.inapphelp.fragments;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ExpandableListAdapter;
import android.widget.ExpandableListView;
import android.widget.TextView;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.google.gson.Gson;
import ru.appsm.inapphelp.R;
import ru.appsm.inapphelp.activities.IAHActivityManager;
import ru.appsm.inapphelp.fragments.IAHFragmentManager;
import ru.appsm.inapphelp.fragments.IAHFragmentParent;
import ru.appsm.inapphelp.fragments.SearchFragment;
import ru.appsm.inapphelp.helper.IAHBaseExpandableListAdapter;
import ru.appsm.inapphelp.logic.IAHSource;
import ru.appsm.inapphelp.logic.IAHUtils;
import ru.appsm.inapphelp.logic.OnFetchedArraySuccessListener;
import ru.appsm.inapphelp.model.IAHKBItem;
import ru.appsm.inapphelp.model.IAHTicket;
import ru.appsm.inapphelp.model.IAHUser;

public class HomeFragment
extends IAHFragmentParent {
    public static final int REQUEST_CODE_NEW_TICKET = 1003;
    private ExpandableListView mExpandableListView;
    private LocalAdapter mAdapter;
    private SearchFragment mSearchFragment;
    private IAHSource gearSource;
    private View rootView;
    private IAHKBItem[] fetchedKbArticles;
    private int numberOfServerCallWaiting = 0;
    protected ExpandableListView.OnChildClickListener expandableChildViewClickListener = new ExpandableListView.OnChildClickListener(){

        public boolean onChildClick(ExpandableListView parent, View v, int groupPosition, int childPosition, long id2) {
            if (groupPosition == 0) {
                IAHKBItem kbItemClicked = (IAHKBItem)HomeFragment.this.mAdapter.getChild(groupPosition, childPosition);
                HomeFragment.this.articleClickedOnPosition(kbItemClicked);
                return true;
            }
            return false;
        }
    };
    protected View.OnClickListener reportIssueClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            HomeFragment.this.gearSource.launchCreateNewTicketScreen(HomeFragment.this, 1003);
        }
    };
    private SearchFragment.OnReportAnIssueClickListener reportAnIssueLisener = new SearchFragment.OnReportAnIssueClickListener(){

        @Override
        public void startReportAnIssue() {
            HomeFragment.this.mSearchFragment.setVisibility(false);
            HomeFragment.this.gearSource.launchCreateNewTicketScreen(HomeFragment.this, 1003);
        }
    };

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.rootView = inflater.inflate(R.layout.iah_fragment_home, container, false);
        this.mExpandableListView = (ExpandableListView)this.rootView.findViewById(R.id.expandableList);
        this.mAdapter = new LocalAdapter((Context)this.getActivity());
        View report_an_issue_view = inflater.inflate(R.layout.iah_expandable_footer_report_issue, null);
        report_an_issue_view.findViewById(R.id.button1).setOnClickListener(this.reportIssueClickListener);
        this.mExpandableListView.addFooterView(report_an_issue_view);
        this.mExpandableListView.setAdapter((ExpandableListAdapter)this.mAdapter);
        this.mExpandableListView.setOnChildClickListener(this.expandableChildViewClickListener);
        this.mSearchFragment = new SearchFragment();
        IAHFragmentManager.putFragmentInActivity(this.getInapphelpActivity(), R.id.search_container, this.mSearchFragment, "Search");
        this.mSearchFragment.setOnReportAnIssueClickListener(this.reportAnIssueLisener);
        this.setHasOptionsMenu(true);
        this.gearSource = IAHSource.getInstance((Context)this.getActivity());
        if (!this.gearSource.isNewUser()) {
            Button mButton = (Button)report_an_issue_view.findViewById(R.id.button1);
            mButton.setText((CharSequence)this.getString(R.string.iah_viewissuebutton_title));
            mButton.setBackgroundColor(this.getResources().getColor(R.color.iah_view_issue_background_color));
            mButton.setTextColor(this.getResources().getColor(R.color.iah_view_issue_text_color));
        }
        if (savedInstanceState == null) {
            this.initializeView();
        } else {
            Gson gson = new Gson();
            this.fetchedKbArticles = (IAHKBItem[])gson.fromJson(savedInstanceState.getString("kbArticles"), IAHKBItem[].class);
            this.numberOfServerCallWaiting = savedInstanceState.getInt("numberOfServerCallWaiting");
            this.mSearchFragment.setKBArticleList(this.fetchedKbArticles);
            if (this.numberOfServerCallWaiting > 0) {
                this.initializeView();
            } else {
                this.refreshList();
            }
        }
        return this.rootView;
    }

    public void onDestroy() {
        super.onDestroy();
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        Gson gson = new Gson();
        outState.putString("kbArticles", gson.toJson((Object)this.fetchedKbArticles));
        outState.putInt("numberOfServerCallWaiting", this.numberOfServerCallWaiting);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1003 && resultCode == -1) {
            IAHUser user = (IAHUser)data.getSerializableExtra("result_user");
            this.refreshList();
            this.gearSource.doSaveNewUserPropertiesForGearInCache(user);
            this.mExpandableListView.setSelectedGroup(1);
            Button mButton = (Button)this.rootView.findViewById(R.id.button1);
            mButton.setText((CharSequence)this.getString(R.string.iah_viewissuebutton_title));
            mButton.setBackgroundColor(this.getResources().getColor(R.color.iah_view_issue_background_color));
            mButton.setTextColor(this.getResources().getColor(R.color.iah_view_issue_text_color));
        }
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater inflater) {
        super.onCreateOptionsMenu(menu2, inflater);
        inflater.inflate(R.menu.iah_search_menu, menu2);
        MenuItem searchItem = menu2.findItem(R.id.search);
        this.mSearchFragment.addSearchViewInMenuItem((Context)this.getActivity(), searchItem);
    }

    public void onDetach() {
        this.gearSource.cancelOperation("FAQ");
        super.onDetach();
    }

    private void initializeView() {
        this.startHomeScreenLoadingDisplay(true);
        this.gearSource.requestKBArticle("FAQ", null, new OnFetchedArraySuccessListener(){

            @Override
            public void onSuccess(Object[] kbArticles) {
                HomeFragment.access$002(HomeFragment.this, (IAHKBItem[])kbArticles);
                HomeFragment.this.mSearchFragment.setKBArticleList(HomeFragment.this.fetchedKbArticles);
                HomeFragment.this.refreshList();
                HomeFragment.this.startHomeScreenLoadingDisplay(false);
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError arg0) {
                HomeFragment.this.startHomeScreenLoadingDisplay(false);
                if (HomeFragment.this.numberOfServerCallWaiting == 0) {
                    IAHUtils.showAlertDialog((Context)HomeFragment.this.getActivity(), HomeFragment.this.getResources().getString(R.string.iah_error), HomeFragment.this.getResources().getString(R.string.iah_error_fetching_articles_issues));
                }
            }
        });
    }

    public void startHomeScreenLoadingDisplay(boolean loading) {
        if (loading) {
            this.numberOfServerCallWaiting = 1;
            this.getInapphelpActivity().setProgressBarIndeterminateVisibility(true);
        } else {
            --this.numberOfServerCallWaiting;
            if (this.numberOfServerCallWaiting == 0 && this.getInapphelpActivity() != null) {
                this.getInapphelpActivity().setProgressBarIndeterminateVisibility(false);
            }
        }
    }

    private void refreshList() {
        this.mAdapter.clearAll();
        this.mAdapter.addParent(0, this.getString(R.string.iah_articles_title));
        if (this.fetchedKbArticles != null) {
            for (int i = 0; i < this.fetchedKbArticles.length; ++i) {
                IAHKBItem item = this.fetchedKbArticles[i];
                this.mAdapter.addChild(0, item);
            }
        }
        this.mAdapter.notifyDataSetChanged();
        this.expandAll();
    }

    private void expandAll() {
        int count = this.mAdapter.getGroupCount();
        for (int i = 0; i < count; ++i) {
            this.mExpandableListView.expandGroup(i);
        }
    }

    protected void articleClickedOnPosition(IAHKBItem kbItemClicked) {
        if (kbItemClicked.getArticleType() == 0) {
            IAHActivityManager.startArticleActivity(this, kbItemClicked, 1003);
        } else {
            IAHActivityManager.startSectionActivity(this, kbItemClicked, 1003);
        }
    }

    static /* synthetic */ IAHKBItem[] access$002(HomeFragment x0, IAHKBItem[] x1) {
        x0.fetchedKbArticles = x1;
        return x1;
    }

    private class LocalAdapter
    extends IAHBaseExpandableListAdapter {
        public LocalAdapter(Context context) {
            super(context);
        }

        @Override
        public View getChildView(int groupPosition, int childPosition, boolean isLastChild, View convertView, ViewGroup parent) {
            ChildViewHolder holder;
            if (convertView == null) {
                convertView = this.mLayoutInflater.inflate(R.layout.iah_expandable_child_home_default, null);
                holder = new ChildViewHolder();
                holder.textView1 = (TextView)convertView.findViewById(R.id.textView1);
                convertView.setTag((Object)holder);
            } else {
                holder = (ChildViewHolder)convertView.getTag();
            }
            if (groupPosition == 0) {
                IAHKBItem item = (IAHKBItem)this.getChild(groupPosition, childPosition);
                holder.textView1.setText((CharSequence)item.getSubject());
            } else if (groupPosition == 1) {
                IAHTicket item = (IAHTicket)this.getChild(groupPosition, childPosition);
                holder.textView1.setText((CharSequence)item.getSubject());
            }
            return convertView;
        }

        @Override
        public View getGroupView(int groupPosition, boolean isExpanded, View convertView, ViewGroup parent) {
            ParentViewHolder holder;
            if (convertView == null) {
                convertView = this.mLayoutInflater.inflate(R.layout.iah_expandable_parent_home_default, null);
                holder = new ParentViewHolder();
                holder.textView1 = (TextView)convertView.findViewById(R.id.textView1);
                convertView.setTag((Object)holder);
            } else {
                holder = (ParentViewHolder)convertView.getTag();
            }
            String text = (String)this.getGroup(groupPosition);
            holder.textView1.setText((CharSequence)text);
            return convertView;
        }

        private class ChildViewHolder {
            TextView textView1;

            private ChildViewHolder() {
            }
        }

        private class ParentViewHolder {
            TextView textView1;

            private ParentViewHolder() {
            }
        }
    }
}

